/*
 * Decompiled with CFR 0.152.
 */
package com.dao;

import com.android.core.utils.params.ParamType;
import com.category.domain.model.ProductCategory;
import com.dao.CheckDao;
import com.dao.HolooSettingsDao;
import com.dao.InvoiceDao;
import com.dao.InvoiceExpenseDao;
import com.dao.SarfaslDao;
import com.dao.SerialDao;
import com.dao.process.BuildArtProcessDao;
import com.dao.process.InvoiceProcessDao;
import com.dao.process.OrderProcessDao;
import com.dao.process.ProcessDao;
import com.dao.process.ReceiveFromCustomerDao;
import com.dao.util.KindVAT;
import com.dao.util.OrderBulkInsert;
import com.dao.util.PreInvoiceBulkInsert;
import com.dao.util.calculatur.ArticleCalcData;
import com.dao.util.calculatur.InvoiceUtils;
import com.dto.CheckDto;
import com.dto.InvoiceDetailDto;
import com.dto.InvoiceDto;
import com.dto.InvoiceExpenseDto;
import com.dto.InvoiceVasetehDto;
import com.dto.LoginDto;
import com.dto.OrderDtlDto;
import com.dto.OrderDto;
import com.dto.PaymentDetailDto;
import com.dto.PaymentDto;
import com.dto.industrial.ArticleSarfasl;
import com.google.gson.Gson;
import com.item_article.data.ItemArticleDao;
import com.service.SettingLoader;
import com.service.invoice.CheckPayError;
import com.service.invoice.ExpenseCalculator;
import com.service.invoice.IncomeCalculator;
import com.service.invoice.ProxyInvoiceService;
import com.service.invoice.commission.CommissionCalculator;
import com.service.invoice.industrial.IndustrialInvoiceService;
import com.utility.ConvertStr;
import com.utility.DateUtils;
import com.utility.DbConnection;
import com.utility.DbLogin;
import com.utility.GetIdentity;
import com.utility.JsonDeserializer;
import com.utility.Paging;
import com.utility.Pair;
import com.utility.SearchQuery;
import com.utility.TextNormalizer;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import com.utility.TncJdbc;
import com.utility.TncLog;
import com.utility.TransactionCheck;
import java.lang.invoke.LambdaMetafactory;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class InvoiceDao {
    private final List<PaymentDetailDto> sndList = new ArrayList();
    private final DbConnection dbConnection;
    private final HolooSettingsDao settingDao;
    private final InvoiceExpenseDao expenseDao;
    private final SarfaslDao sarfaslDao;
    private final TncLog log;
    private ItemArticleDao itemArticleDao;
    private ExpenseCalculator expenseCalculator;
    private IncomeCalculator incomeCalculator;
    private int Min_CodeSanad = 0;
    private int Max_CodeSanad = 0;

    public InvoiceDao(DbConnection dbConnection, HolooSettingsDao settingDao, InvoiceExpenseDao expenseDao, SarfaslDao sarfaslDao, TncLog log) {
        this.dbConnection = dbConnection;
        this.settingDao = settingDao;
        this.expenseDao = expenseDao;
        this.sarfaslDao = sarfaslDao;
        this.log = log;
    }

    @Autowired
    public void setExpenseCalculator(ExpenseCalculator expenseCalculator) {
        this.expenseCalculator = expenseCalculator;
    }

    @Autowired
    public void setIncomeCalculator(IncomeCalculator incomeCalculator) {
        this.incomeCalculator = incomeCalculator;
    }

    @Autowired
    public void setItemArticleDao(ItemArticleDao itemArticleDao) {
        this.itemArticleDao = itemArticleDao;
    }

    public ResponseEntity<?> getInvoiceList(HttpServletRequest request) {
        Object rowSet;
        LoginDto myLogin = this.dbConnection.setToken();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
        String sqlStr = " select distinct f.fac_code, f.Fac_Code_C Code, f.Fac_Type Type, ISNULL(u.name,'') UserName, s.Sanad_Code_c SanadCode, \n f.FAC_COMMENT comment, C.C_Name CustomerName,c.C_Mobile Mobile , C.C_Code CustomerErpCode, C.C_CODE_C customerCodeC, \n convert(nvarchar(10), f.Fac_Date, 111) [Date], convert(nvarchar(8), f.Fac_Time, 108) [Time], \n f.FNaghd SumNaghd, f.Card SumCard, f.FNesieh SumNesiyeh, f.Takhfif SumDiscount, \n f.FCheck SumCheck, f.Sum_Levy SumLevy, f.Sum_Scot SumScot, f.Sum_Price SumPrice, \n(SELECT count(*) From FCOUNECT where fac_code = f.Fac_Code and fac_type = f.Fac_Type and a_code is null) vasetehCount, f.Fac_Code ErpCode, f.sanad_code, convert(nvarchar(10), f.tasviehDate, 111) settleDate, \n (CASE WHEN isNull(ftaxid, '') = '' \n THEN CASE WHEN Charindex(',', FTaxIdLog) > 0 \n THEN REVERSE(LEFT(REVERSE(FTaxIdLog), CHARINDEX(',', REVERSE(FTaxIdLog)) - 1)) \n ELSE FTaxIdLog END \n ELSE FTaxId END) fTaxId \n from Facture f \n left join USERDB u On u.userCodeInc = f.usercode \n Inner join Customer c On c.C_Code = f.C_Code \n Inner join Sanad s On s.sanad_code = f.sanad_Code ";
        Map info = ConvertStr.rebuildQueryString((HttpServletRequest)request);
        int itemsPerPage = ConvertStr.parseNullSafeInt((String)info.getOrDefault("itemsperpage", "0"));
        int page = ConvertStr.parseNullSafeInt((String)info.getOrDefault("page", "0"));
        Paging paging = new Paging(itemsPerPage, page, "FACTURE");
        String sqlWhere = this.getFilter(info);
        String keyField = "FAC_CODE";
        if (info.containsKey("type")) {
            if (((String)info.get("type")).equals("5")) {
                sqlStr = "Select Count(*) cnt From sysColumns Where [Name] = 'Id' And [id]=( Select [id] From Sysobjects where [Name] = 'Fbailpre'  And [xtype] = 'U' )";
                rowSet = jdbcTemplate.queryForRowSet(sqlStr);
                String FErpCode = "f.Fac_Code";
                while (rowSet.next()) {
                    if (rowSet.getInt("cnt") <= 0) continue;
                    FErpCode = ",f.id ErpCode";
                }
                sqlStr = "select f.Fac_Code, f.Fac_Code_C Code, f.Fac_Type Type, ISNULL(u.name,'') UserName, 0 SanadCode, c.C_Mobile Mobile , C.C_Name CustomerName, C.C_Code CustomerErpCode, convert(nvarchar(10), f.Fac_Date, 111) Date, convert(nvarchar(8), f.Fac_Time, 108) Time,   0 SumNaghd, 0 SumCard, 0 SumNesiyeh, Isnull(f.Takhfif,0) SumDiscount, 0 SumCheck,(SELECT count(*) From ABAILPRE where fac_code = f.Fac_Code and fac_type = f.Fac_type and isnull(Vaseteh_Code,'')<>'') vasetehCount,f.VasetehCode VasetehCode, f.Sum_Levy SumLevy,f.Sum_Scot SumScot,f.Sum_Price SumPrice" + FErpCode + " , f.Fac_Comment Comment,(select C_Name from customer where C_Code = f.VasetehCode ) vasetehName , f.VasetehPrice VasetehPrice from  Fbailpre f  left join USERDB u On u.userCodeInc = f.usercode \n Inner join Customer c On c.C_Code = f.C_Code ";
            } else if (((String)info.get("type")).equals("6") || ((String)info.get("type")).equals("8")) {
                sqlStr = "select f.RqIndex Fac_Code, f.RqIndex2 Code, F.RqType Type, 0 SanadCode, \n C.C_Name CustomerName,c.C_Mobile Mobile , C.C_Code CustomerErpCode, convert(nvarchar(10), f.T_Date, 111) Date, \n convert(nvarchar(8), f.T_Time, 108) Time, 0 SumNaghd, 0 SumCard, 0 SumNesiyeh, \n 0 SumDiscount, 0 SumCheck, 0 SumLevy, 0 SumScot, F.SumPrice SumPrice, f.RqIndex ErpCode, f.Comment Comment, \n(select C_Name from customer where C_Code = f.Vaseteh_Code ) vasetehName,(SELECT count(*) From FCOUNECT where fac_code = f.rqIndex and fac_type = f.rqType) vasetehCount,\n u.[Name] UserName \n from rqtitle f \n Inner join Customer c On c.C_Code = f.R_CusCode \n Inner Join UserDb u On u.UserCodeInc = f.UserName ";
            }
        } else {
            keyField = "SANAD_CODE";
        }
        sqlStr = paging.makeSql(Paging.PageSqlData.builder().selectSqlStr(sqlStr).whereStr(sqlWhere).alias("f").keyField(keyField).build());
        rowSet = jdbcTemplate.queryForList(sqlStr);
        String sqlDetailStr = sqlStr;
        sqlDetailStr = sqlDetailStr.replace("drop table #tmp_table", "");
        sqlDetailStr = sqlDetailStr.substring(0, sqlDetailStr.indexOf("SELECT * FROM #tmp_table f"));
        sqlStr = this.GetInvoiceDetailQuery(info, sqlDetailStr);
        List rowSetDetail = jdbcTemplate.queryForList(sqlStr);
        for (int i = 0; i < rowSet.size(); ++i) {
            Map map = (Map)rowSet.get(i);
            String typeLetter = map.get("Type").toString();
            String titleId = ConvertStr.getNullIfEmpty((String)map.remove("ErpCode").toString());
            if (!myLogin.getIsMyHoloo().booleanValue() && !myLogin.getIsTorfehNegar().booleanValue()) {
                map.put("ErpCode", ConvertStr.encrypt((String)titleId));
            } else {
                map.put("InvoiceId", titleId);
            }
            String customerId = ConvertStr.getNullIfEmpty((String)map.remove("CustomerErpCode").toString());
            if (myLogin.getIsMyHoloo().booleanValue()) {
                map.put("CustomerId", customerId);
            } else {
                map.put("CustomerErpCode", ConvertStr.encrypt((String)customerId));
            }
            if (info.containsKey("type") && (((String)info.get("type")).equals("6") || ((String)info.get("type")).equals("8"))) {
                map.put("Type", ConvertStr.setTypeOfFactureWithRqType((String)map.get("Type").toString()));
            } else {
                map.put("Type", ConvertStr.setTypeOfFacture((String)map.get("Type").toString()));
            }
            map.put("TypeName", ConvertStr.setTypeNameOfFacture((int)((Integer)map.get("Type"))));
            ArrayList<Map> mapDetailList = new ArrayList<Map>();
            for (Map mapDetail : rowSetDetail) {
                List serials;
                Object facCode = mapDetail.get("fac_code");
                Object facType = mapDetail.get("type");
                if (!map.get("fac_code").equals(facCode) || !typeLetter.equals(facType)) continue;
                Object aCode = mapDetail.get("A_Code");
                Object connectCode = mapDetail.get("ConnectCode");
                Object row = mapDetail.get("Row");
                double darsadPorsant = 0.0;
                if (mapDetail.containsKey("DarsadPorsant")) {
                    darsadPorsant = (Double)mapDetail.get("DarsadPorsant");
                }
                if (!ConvertStr.isNullOrEmpty((Collection)(serials = jdbcTemplate.queryForList(" SELECT A_SERIAL FROM FAC_SER WHERE FAC_CODE = ? AND FAC_TYPE = ? AND A_CODE = ?", String.class, new Object[]{facCode, typeLetter, mapDetail.get("ProductErpCode")})))) {
                    mapDetail.put("serials", serials);
                }
                if (map.get("Type").equals(5)) {
                    if (darsadPorsant == 0.0) {
                        map.put("Vaseteh", this.getMidMenAttributePreInvoice((String)facCode, (String)facType, (JdbcTemplate)jdbcTemplate));
                    } else {
                        String vasetehCode = (String)mapDetail.get("Vaseteh_Code");
                        mapDetail.put("Vaseteh", this.getMidMenAttributesForPreInvoicePorsantSatre((String)aCode, (String)facCode, (String)facType, vasetehCode, (JdbcTemplate)jdbcTemplate));
                    }
                } else if (connectCode != null) {
                    mapDetail.put("Vaseteh", this.getMidMenAttributeswithPorsantSatre((String)facCode, typeLetter, String.valueOf(row), (JdbcTemplate)jdbcTemplate));
                }
                if (facCode instanceof String && aCode == null && (Integer)map.get("vasetehCount") > 0) {
                    map.put("Vaseteh", this.getMidMenAttributes((String)facCode, typeLetter, (JdbcTemplate)jdbcTemplate));
                }
                String productID = ConvertStr.getNullIfEmpty((String)mapDetail.remove("ProductErpCode").toString());
                if (myLogin.getIsMyHoloo().booleanValue()) {
                    mapDetail.put("ProductId", productID);
                } else {
                    mapDetail.put("ProductErpCode", ConvertStr.encrypt((String)productID));
                }
                mapDetail.remove("fac_code");
                mapDetail.remove("type");
                mapDetail.remove("Vaseteh_Code");
                mapDetail.remove("ConnectCode");
                mapDetailList.add(mapDetail);
            }
            map.put("Detail", mapDetailList);
            map.remove("fac_code");
            map.remove("vasetehCount");
            map.remove("VasetehCode");
            rowSet.set(i, map);
        }
        return ConvertStr.getMapResponseEntity((String)"invoice", (List)rowSet, (boolean)TextNormalizer.isFarsi((HttpServletRequest)request));
    }

    private List<Map<String, Object>> getMidMenAttributes(String facCode, String typeLetter, JdbcTemplate jdbcTemplate) {
        List midMan = jdbcTemplate.queryForList("select  fc.Darsad_Porsunt  DarsadPorsant, fc.Cust_Porsunt custPorsant,fc.c_code ErpCode ,c.c_name V_Name from FACTURE f \nleft join FCOUNECT fc On fc.Fac_Code = f.Fac_Code and fc.Fac_Type = f.Fac_Type\nleft join CUSTOMER c on c.c_code = fc.counect_code \nwhere f.Fac_Code = ? and f.Fac_Type = ? group by f.Fac_Code , f.Fac_Type , f.Sum_Price , fc.C_Code , c.C_Name , fc.Darsad_Porsunt , fc.Cust_Porsunt ", new Object[]{facCode, typeLetter});
        for (Map m : midMan) {
            m.put("ErpCode", ConvertStr.encrypt((String)((String)m.get("ErpCode"))));
        }
        return midMan;
    }

    private Map<String, Object> getMidMenAttributePreInvoice(String facCode, String facType, JdbcTemplate jdbcTemplate) {
        Map midMan = jdbcTemplate.queryForMap("select f.VasetehPrice , c.c_name , f.C_Code c_code\nfrom fbailpre f \nleft join CUSTOMER c on c.c_code = f.VasetehCode \nwhere f.Fac_Code = ? and fac_type = ?", new Object[]{facCode, facType});
        midMan.put("ErpCode", ConvertStr.encrypt((String)((String)midMan.get("c_code"))));
        return midMan;
    }

    private Map<String, Object> getMidMenAttributeswithPorsantSatre(String facCode, String typeLetter, String row, JdbcTemplate jdbcTemplate) {
        Map midMan = jdbcTemplate.queryForMap("select distinct fc.Counect_Code code, c.c_code ErpCode ,c.C_Name name , fa.DarsadPorsant ,                ((fa.Price_BS*fa.DarsadPorsant * fa.Few_Article)/100) Cust_Porsunt  \n                from facture f \n                left join FCOUNECT fc On fc.Fac_Code = f.Fac_Code and fc.Fac_Type = f.Fac_Type \n                left join factart fa On fa.Fac_Code = f.Fac_Code and fa.Fac_Type = f.Fac_Type and fc.Counect_Code = fa.Vaseteh_Code \n                left join CUSTOMER c on c.c_code = fc.counect_code  where f.fac_code = ? and  f.fac_type = ?  and fa.[A_Index] = ? ", new Object[]{facCode, typeLetter, row});
        midMan.put("ErpCode", ConvertStr.encrypt((String)((String)midMan.get("ErpCode"))));
        return midMan;
    }

    private Map<String, Object> getMidMenAttributesForPreInvoicePorsantSatre(String aCode, String facCode, String facType, String vasetehCode, JdbcTemplate jdbcTemplate) {
        String sql = vasetehCode.equals("") ? "select DISTINCT f.Vaseteh_Code code, ISNULL(c.c_code,'') ErpCode ,ISNULL(c.C_Name, '')name ,\n f.DarsadPorsant ,((f.DarsadPorsant / 100) * f.Price_BS) Cust_Porsunt from ABAILPRE f\n  left join fbailpre fb on fb.fac_code = f.fac_code   left join CUSTOMER c on c.c_code = f.Vaseteh_Code  where f.A_code = ? and f.fac_code = ? and f.fac_type = ?" : "select DISTINCT f.Vaseteh_Code code, ISNULL(c.c_code,'') ErpCode ,ISNULL(c.C_Name, '')name , f.DarsadPorsant ,\n ((f.DarsadPorsant / 100) * f.Price_BS * f.Few_Article) Cust_Porsunt from ABAILPRE f \n left join CUSTOMER c on c.c_code = f.Vaseteh_Code  where f.A_code = ? and f.fac_code = ? and f.fac_type = ?";
        Map midMan = jdbcTemplate.queryForMap(sql, new Object[]{aCode, facCode, facType});
        midMan.put("ErpCode", ConvertStr.encrypt((String)((String)midMan.get("ErpCode"))));
        return midMan;
    }

    @Language(value="SQL")
    private String GetInvoiceDetailQuery(Map<String, String> info, String rootQuery) {
        String sqlStr = "SELECT distinct fa.fac_code, fa.A_Index Row, a.A_Code_C ProductCode, a.A_Name ProductName, \n fc.Counect_Code ConnectCode, fa.Vaseteh_Code Vaseteh_Code, \n fc.A_code  A_Code ,ISNULL(fa.DarsadPorsant,0) DarsadPorsant,\n a.A_Code ProductErpCode, fa.Few_Article Few, fa.few_article2 Karton, fa.FewBasteh basteh, fa.Price_BS Price, \n fa.FacArtic_Comment comment, (fa.Few_Article * fa.Price_BS) SumPrice, \n fa.Levy Levy, fa.Scot Scot,fa.Fac_Type type, fa.DarsadTakhfif PersentDiscount, fa.TakhfifSatriR Discount \n FROM Factart fa \n INNER JOIN Article a ON a.a_code = fa.a_code \n left join  FCOUNECT fc ON   fc.Counect_Code = fa.Vaseteh_Code and fc.Fac_Code = fa.Fac_Code and fa.Fac_Type = fc.Fac_Type and fc.[Priority] = fa.A_Index \n inner join  #tmp_table tmp on  tmp.Fac_Code=fa.Fac_Code and tmp.Type= fa.Fac_Type ";
        String FOrderby = " ORDER BY fa.Fac_Code,fa.A_Index \n";
        if (info.containsKey("type")) {
            if (info.get("type").equals("5")) {
                sqlStr = "SELECT fa.Fac_Code, fa.A_Index Row, a.A_Code_C ProductCode, fa.Vaseteh_Code ConnectCode, fa.A_Code A_Code, \n a.A_Name ProductName, a.A_Code ProductErpCode, fa.Few_Article / unit_few Few, \n fa.few_article2 Karton, fa.Basteh basteh, fa.Price_BS Price, fa.Fac_Type type, \n  ((fa.Few_Article / unit_few)*fa.Price_BS) SumPrice, fa.Levy Levy, fa.Scot Scot,fa.Vaseteh_Code, ISNULL(fa.DarsadPorsant,0) DarsadPorsant,\n Isnull(fa.DarsadTakhfif, 0) PersentDiscount, isnull(fa.TakhfifSatriR, 0) Discount, \n fa.FacArtic_Comment Comment  FROM abailpre fa \n  INNER JOIN Article a on a.a_code = fa.a_code \n inner join  #tmp_table tmp on  tmp.Fac_Code=fa.Fac_Code and tmp.Type= fa.Fac_Type and unit_few != 0";
            } else if (info.get("type").equals("6") || info.get("type").equals("8")) {
                sqlStr = "SELECT fa.RqIndex Fac_Code, (Select COUNT(*) from RQDETAIL fa2  where fa2.RqIndex = fa.RqIndex and fa2.RqIncIndex <= fa.RqIncIndex) as Row, fa.R_ArCode, fa.R_ArCode , a.A_Code_C ProductCode,  \n a.A_Name ProductName, a.A_Code ProductErpCode, \n fa.R_Few Few,fa.FewKarton Karton, fa.FewBasteh basteh, fa.R_Cost Price, fa.RqType type, \n (fa.R_Few * fa.R_Cost) SumPrice, 0 Levy, 0 Scot , 0 PersentDiscount, 0 Discount, fa.R_Commen Comment\n FROM RqDetail fa \n INNER JOIN Article a ON a.a_code = fa.R_ArCode \n inner join  #tmp_table tmp on  tmp.Fac_Code = fa.RqIndex \n";
                FOrderby = " ORDER BY fa.RqIndex, fa.RqIncIndex \n";
            }
        }
        String where = "";
        if (info.get("page") != null) {
            where = " WHERE tmp.FAC_CODE in (Select TableKey from @orderedKeys where TableKey = tmp.FAC_CODE AND RowNum >= @firstRecord) \n";
        }
        sqlStr = rootQuery + sqlStr + where + FOrderby + " drop table #tmp_table";
        return sqlStr;
    }

    public ResponseEntity<?> getInvoiceInfo(HttpServletRequest request, int RegisterType2) {
        LoginDto myLogin = this.dbConnection.setToken();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
        String fieldName = "FbailPreId";
        if (RegisterType2 == 0) {
            fieldName = "OrderId";
        }
        String sqlStr = " Select f.Fac_Code_C Code,s.Sanad_Code_c SanadCode," + fieldName + " ErpCode  from Facture f  Inner join Sanad s On s.sanad_code = f.sanad_Code ";
        StringBuilder sqlWhere = new StringBuilder();
        Map info = ConvertStr.rebuildQueryString((HttpServletRequest)request);
        if (info.containsKey("erpcode")) {
            sqlWhere.append(" WHERE ").append(fieldName).append(" = '").append(ConvertStr.decrypt((String)((String)info.get("erpcode")))).append("'");
        }
        if (sqlWhere.toString().isEmpty()) {
            sqlWhere = new StringBuilder(" Where isNull(" + fieldName + ", 0) > 0 ");
        }
        sqlStr = sqlStr + sqlWhere + " order by " + fieldName;
        List rowSet = jdbcTemplate.queryForList(sqlStr);
        for (int i = 0; i < rowSet.size(); ++i) {
            Map map = (Map)rowSet.get(i);
            map.put("ErpCode", ConvertStr.encrypt((String)ConvertStr.getNullIfEmpty((String)map.get("ErpCode").toString())));
            rowSet.set(i, map);
        }
        return ConvertStr.getMapResponseEntity((String)"invoiceinfo", (List)rowSet, (boolean)TextNormalizer.isFarsi((HttpServletRequest)request));
    }

    public ResponseEntity<?> getTmpInvoiceList(HttpServletRequest request) {
        LoginDto myLogin = this.dbConnection.setToken();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
        String sqlStr = " select Id, FType, C_Code, C_CodeVaseteh, convert(nvarchar(19), FDateTime, 120) FDateTime, \n FNaghd, FNaghdSarfasl, FCard, \n FCardSarfasl, Takhfif, FNesiyeh, Comment, Kind, WebId, C_Code_C, SumLevy, SumScot \n From TmpFacture f \n";
        String sqlWhere = this.filterTmpInvoice(request);
        String fOrderBy = "  order by FDateTime";
        sqlStr = sqlStr + sqlWhere + fOrderBy;
        List rowSet = jdbcTemplate.queryForList(sqlStr);
        sqlStr = "Select IDFacture,A_Code,A_few,A_Few2,A_Price,Unit_code,A_Comment,Levy,Scot, DarsadTakhfif, TakhfifSatriR, A_Index From TmpFactart ";
        List rowSetDetail = jdbcTemplate.queryForList(sqlStr);
        sqlStr = " SELECT FAC_CODE, Fac_Type, A_Code, A_Index, PoshakIDF, Few, Price FROM ITEMFACT";
        List itemFactList = jdbcTemplate.queryForList(sqlStr);
        for (int i = 0; i < rowSet.size(); ++i) {
            Map map = (Map)rowSet.get(i);
            ArrayList<Map> mapDetailList = new ArrayList<Map>();
            for (Map mapDetail : rowSetDetail) {
                if (!map.get("ID").equals(mapDetail.get("IDFacture"))) continue;
                List mapPoshakList = this.getPoshakList(itemFactList, mapDetail);
                mapDetail.put("Poshak", mapPoshakList);
                mapDetailList.add(mapDetail);
            }
            map.put("Detail", mapDetailList);
            rowSet.set(i, map);
        }
        return ConvertStr.getMapResponseEntity((String)"invoice", (List)rowSet, (boolean)TextNormalizer.isFarsi((HttpServletRequest)request));
    }

    private List<Map<String, Object>> getPoshakList(List<Map<String, Object>> itemFactList, Map<String, Object> detailMap) {
        ArrayList<Map<String, Object>> mapPoshakList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> mapItemFact : itemFactList) {
            int itemFactId = Integer.parseInt((String)mapItemFact.getOrDefault("FAC_CODE", "0"));
            int tmpFactId = (Integer)detailMap.get("IDFacture");
            String itemFactACode = (String)mapItemFact.getOrDefault("A_Code", "0");
            String tmpFactArtACode = (String)detailMap.get("A_Code");
            if (tmpFactId != itemFactId || !itemFactACode.equals(tmpFactArtACode)) continue;
            mapItemFact.remove("FAC_CODE");
            mapItemFact.remove("A_Code");
            mapPoshakList.add(mapItemFact);
        }
        return mapPoshakList;
    }

    private void ReturnMinMax_CodeSanad_For_OneDay(JdbcTemplate jdbcTemplate, String OneDay) {
        boolean lastDate = false;
        String sqlStr = " SELECT     MAX(Sanad_Code_C) AS Code   FROM      dbo.SANAD  WHERE     (Sanad_Date < '" + OneDay + "') ";
        SqlRowSet rs = jdbcTemplate.queryForRowSet(sqlStr);
        while (rs.next()) {
            this.Min_CodeSanad = rs.getInt("Code") + 1;
        }
        sqlStr = " SELECT     MIN(Sanad_Code_C) AS Code   FROM      dbo.SANAD  WHERE     (Sanad_Date > '" + OneDay + "') ";
        rs = jdbcTemplate.queryForRowSet(sqlStr);
        while (rs.next()) {
            this.Max_CodeSanad = rs.getInt("Code");
        }
        if (this.Max_CodeSanad == 0) {
            sqlStr = " SELECT  MAX(Sanad_Code_C) AS Code  FROM    dbo.SANAD  WHERE   (Sanad_Date <= '" + OneDay + "') ";
            rs = jdbcTemplate.queryForRowSet(sqlStr);
            while (rs.next()) {
                this.Max_CodeSanad = rs.getInt("Code") + 1;
            }
            lastDate = true;
        }
        if (!lastDate) {
            if (this.Min_CodeSanad < this.Max_CodeSanad) {
                --this.Max_CodeSanad;
            } else if (this.Min_CodeSanad == this.Max_CodeSanad) {
                --this.Min_CodeSanad;
                this.Max_CodeSanad = this.Min_CodeSanad;
            }
            if (this.Max_CodeSanad < this.Min_CodeSanad) {
                this.Min_CodeSanad = this.Max_CodeSanad;
            }
            if (this.Max_CodeSanad < 2) {
                this.Max_CodeSanad = 2;
                this.Min_CodeSanad = 2;
            }
        }
    }

    private int returnSanadCode2(JdbcTemplate jdbcTemplate, int sanadCode, String sanadDate) {
        int sanadCode2 = 0;
        sanadDate = sanadDate.replace("-", "/");
        String sqlStr = " SELECT   MAX(Sanad_Code_C2)+1 MAXSanad_Code_C2  FROM         dbo.SANAD  WHERE     (Sanad_Code_C = " + sanadCode + ") and (Sanad_Date <= '" + sanadDate + "' ) ";
        SqlRowSet rs = jdbcTemplate.queryForRowSet(sqlStr);
        if (rs.next()) {
            sanadCode2 = rs.getInt("MAXSanad_Code_C2");
        }
        return sanadCode2;
    }

    private void incSanadCode(JdbcTemplate jdbcTemplate, int firstCode, int firstCode2) {
        int sanadCode2 = 0;
        String sqlStr = " SELECT     COUNT(*) COUNTSANAD  FROM         dbo.SANAD  WHERE     Sanad_Code_C = " + firstCode + " And Sanad_Code_C2=" + firstCode2;
        SqlRowSet rs = jdbcTemplate.queryForRowSet(sqlStr);
        if (rs.next()) {
            sanadCode2 = rs.getInt("COUNTSANAD");
        }
        if (sanadCode2 > 0 && (rs = jdbcTemplate.queryForRowSet(sqlStr = " SELECT     COUNT(Sanad_Code_C) AS Code  FROM         dbo.SANAD  WHERE     (Sanad_Code_C = " + firstCode + ") ")).next() && rs.getInt("Code") > 0) {
            sqlStr = " UPDATE    Sanad  SET       Sanad_Code_C2 = Sanad_Code_C2 + 1  WHERE     Sanad_Code_C = " + firstCode + " AND Sanad_Code_C2 >= " + firstCode2;
            jdbcTemplate.execute(sqlStr);
        }
    }

    private void sanadAdd(PaymentDetailDto.Builder paymentBuilder) {
        this.sndList.add(paymentBuilder.build());
    }

    private StringBuilder getInsertFactureStatement() {
        StringBuilder sb = new StringBuilder();
        sb.append("Insert into Facture(Fac_code,Fac_type,Fac_code_c,C_Code,Fac_Date,Fac_Time,Sanad_Code,Sum_price,Sum_few,").append("FNaghd,FCheck,FNesieh,TasviehDate,Takhfif,UserCode,HlpFieldL,").append("DateUser,TimeUser,Card,Kind_Vat,Sum_Levy,Sum_Scot,IsLevyAndScot,Fac_Comment)");
        return sb;
    }

    private void appendSelectFactureStatement(StringBuilder sb, InvoiceDto.InvoiceInfo p) {
        sb.append(" ( ").append("'").append(p.getId()).append("',").append("'").append(p.getType()).append("',").append("'").append(p.getCode()).append("',").append("'").append(p.getCustomerid()).append("',").append("'").append(p.getDate()).append("',").append("'").append(p.getTime()).append("',").append(p.getSanadcode()).append(",").append(p.getSumprice()).append(",").append(p.getSumfew()).append(",").append(p.getCash()).append(",").append(p.getSumcheck()).append(",").append(p.getNesiyeh()).append(",").append("'").append(ConvertStr.nullSafeString((String)p.getTasviehdate())).append("',").append(p.getDiscount()).append(",").append(p.getUsercode()).append(",").append(ConvertStr.getBoolToInt((Boolean)p.getHlpfieldl())).append(",").append("'").append(ConvertStr.nullSafeString((String)p.getDateuser())).append("',").append("'").append(ConvertStr.nullSafeString((String)p.getTimeuser())).append("',").append(p.getBank()).append(",").append(p.getKindvat()).append(",").append(p.getLevy()).append(",").append(p.getScot()).append(",").append(ConvertStr.getBoolToInt((Boolean)p.getIslevyandscot())).append(",").append("'").append(ConvertStr.nullSafeString((String)p.getComment())).append("'").append(" ) ");
    }

    private StringBuilder getInsertFactartStatement() {
        StringBuilder sb = new StringBuilder();
        sb.append("Insert into Factart(Fac_Code,Fac_Type,A_Code,A_Index,Few_Article,few_article2,Price_Bs,Buy_Price,ACode_C,").append("vahedcode,VahedFew,FacArtic_Comment,FewKarton,Levy,Scot,DarsadTakhfif,DarsadPorsant,TakhfifSatriR,ArtExist)");
        return sb;
    }

    private void appendSelectFactartStatement(StringBuilder sb, InvoiceDetailDto p) {
        sb.append(" ( ").append("'").append(p.getId()).append("',").append("'").append(p.getType()).append("',").append("'").append(p.getProductid()).append("',").append(p.getAindex()).append(",").append(p.getFew()).append(",").append(p.getFew2()).append(",").append(p.getPrice()).append(",").append(p.getBuyprice()).append(",").append("'").append(p.getProductcode()).append("',").append(p.getUnitid()).append(",").append(p.getUnitfew()).append(",").append("'").append(ConvertStr.nullSafeString((String)p.getComment())).append("',").append(p.getKarton()).append(",").append(p.getLevy()).append(",").append(p.getScot()).append(",").append(p.getPersentdiscount()).append(",").append(p.getDiscount()).append(",").append(p.getPersentporsant()).append(",").append(p.getArtexist()).append(" ) ");
    }

    public synchronized ResponseEntity<Map<String, Object>> postInvoiceList(String Msg, int FRegisterType, boolean rebuildJson, Request request) {
        LoginDto myLogin = this.dbConnection.setToken();
        try {
            TransactionCheck t = TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)myLogin.getDatabaseName());
            t.waitTranEndForTables(new String[]{"FACTURE", "FACTART", "TMPFACTURE", "RQTITLE", "RQDETAIL", "FBAILPRE", "ABAILPRE", "ARTICLE, FAC_BILD, Vaset_Factor_Tolid"});
            return (ResponseEntity)this.dbConnection.getTransactionTemplate(myLogin).execute(status -> this.postInvoice(Msg, FRegisterType, rebuildJson, myLogin, false, request));
        }
        catch (TncException e) {
            return ConvertStr.getMapResponseEntity((String)"Invoice", (List)e.makeFailureList(), (List)e.getSuccessList());
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized ResponseEntity<Map<String, Object>> deleteInvoiceList(String[] params, Request request) {
        LoginDto myLogin = this.dbConnection.setToken();
        try {
            TransactionCheck t = TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)myLogin.getDatabaseName());
            t.waitTranEndForTables(new String[]{"FACTURE", "FACTART"});
            return (ResponseEntity)this.dbConnection.getTransactionTemplate(myLogin).execute(status -> this.deleteInvoiceLists(params, request));
        }
        catch (TncException e) {
            return ConvertStr.getMapResponseEntity((String)"Invoice", (List)e.makeFailureList(), (List)e.getSuccessList());
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public synchronized ResponseEntity<Map<String, Object>> postInvoice(String msg, int FRegisterType, boolean rebuildJson, LoginDto myLogin, boolean isInLoop, Request request) {
        block260: {
            block257: {
                block258: {
                    block259: {
                        block261: {
                            failure = new ArrayList<Map>();
                            success = new ArrayList<LinkedHashMap<K, V>>();
                            exceptions = new ArrayList<TncException>();
                            jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
                            settingLoader = new SettingLoader(this.dbConnection, myLogin);
                            checkDao = new CheckDao(this.dbConnection, myLogin);
                            try {
                                holder = new InvoiceSetupValueHolder(new SettingLoader(this.dbConnection, myLogin));
                                holder.fetch();
                                try {
                                    if (rebuildJson) {
                                        invoiceInfo = (InvoiceDto.InvoiceInfo[])new JsonDeserializer(InvoiceDto.InvoiceInfo[].class).makeDtoArray(msg, "invoiceinfo");
                                        this.log.info(myLogin.getDatabaseName() + " INPUT JSON = " + msg);
                                    } else {
                                        msg = msg.substring(15, msg.length() - 1);
                                        gson = new Gson();
                                        invoiceInfo = (InvoiceDto.InvoiceInfo[])gson.fromJson(msg, InvoiceDto.InvoiceInfo[].class);
                                    }
                                }
                                catch (Exception ex) {
                                    e = new TncException(TncExceptionMessages.WRONG_JSON_STRUCT);
                                    if (myLogin.getIsTorfehNegar().booleanValue()) {
                                        e.putMoreInfo("ErrorMessage", (Object)ex.getMessage());
                                    }
                                    failure.add(e.getErrorMap());
                                    return ConvertStr.getMapResponseEntity((String)"Invoice", failure, success);
                                }
                                if (myLogin.getIsMyHoloo().booleanValue() && invoiceInfo.length > 0 && !ConvertStr.isNullOrEmpty((String)invoiceInfo[0].getFac_code())) {
                                    return this.postInvoiceListOnly(myLogin, invoiceInfo);
                                }
                                myProduct = new ArrayList<LinkedHashMap<K, V>>();
                                sanadCode = 0;
                                block18: for (InvoiceDto.InvoiceInfo invoice : invoiceInfo) {
                                    errorProductCode = null;
                                    try {
                                        block263: {
                                            block262: {
                                                this.sndList.clear();
                                                invoice.setInputid(invoice.getId());
                                                if (ConvertStr.isNullOrEmpty((Collection)invoice.getDetailinfo())) {
                                                    throw new TncException(TncExceptionMessages.NO_INVOICE_DETAIL_PROVIDED);
                                                }
                                                if (ConvertStr.isNullOrEmpty((String)invoice.getType())) {
                                                    throw new TncException(TncExceptionMessages.INVALID_INVOICE_TYPE);
                                                }
                                                if (myLogin.getIsMyHoloo().booleanValue() && invoice.getKind() == null) {
                                                    throw new TncException(TncExceptionMessages.INVALID_INVOICE_TYPE);
                                                }
                                                type = Integer.parseInt(invoice.getType());
                                                invoiceType = InvoiceType.getInvoiceType((int)type, (int)FRegisterType);
                                                invoice.setType(invoiceType.getSymbol());
                                                invoice.setInvoiceType(invoiceType);
                                                if (invoice.getVaseteh() != null && invoice.getVaseteh().size() > 0) {
                                                    vaseteh = new ArrayList<String>();
                                                    rs = jdbcTemplate.queryForRowSet("select c_code from customer where Vaseteh = 1");
                                                    while (rs.next()) {
                                                        vaseteh.add(ConvertStr.encrypt((String)rs.getString("c_code")));
                                                    }
                                                    for (i = 0; i < invoice.getVaseteh().size(); ++i) {
                                                        if (vaseteh.contains(((InvoiceVasetehDto)invoice.getVaseteh().get(i)).getMidmanerpcode())) continue;
                                                        throw new TncException(TncExceptionMessages.INVALID_VASETEH_ERPCODE);
                                                    }
                                                    if (!settingLoader.isSlctMoreThan1Vaseteh()) {
                                                        if (settingLoader.PorsantSatri() && !settingLoader.NoPorsant()) {
                                                            throw new TncException(TncExceptionMessages.SET_SETTING_ON_HECHKODAM);
                                                        }
                                                        if (invoice.getVaseteh().size() > 1) {
                                                            throw new TncException(TncExceptionMessages.SET_SETTING_ON_CHAND_VASTEH);
                                                        }
                                                    }
                                                    if (settingLoader.SaveCustForVaseteh()) {
                                                        rs = jdbcTemplate.queryForRowSet("Select Sarfasl_Code from Sarfasl\nWhere Type = (Select [ID] from sarfaslType where DefaultSarfasl = '6010008')");
                                                        sarfaslCodes = new ArrayList<String>();
                                                        while (rs.next()) {
                                                            sarfaslCodes.add(rs.getString("Sarfasl_Code"));
                                                        }
                                                        for (InvoiceVasetehDto dto : invoice.getVaseteh()) {
                                                            if (dto.getSarfaslcodehazineh() == null || sarfaslCodes.contains(dto.getSarfaslcodehazineh())) continue;
                                                            throw new TncException(TncExceptionMessages.INVALID_SARFASL_HAZINEH);
                                                        }
                                                    }
                                                }
                                                oldPriceOrder = 0.0;
                                                oldBeianeh = 0.0;
                                                if (!myLogin.getIsMyHoloo().booleanValue() && (rs = jdbcTemplate.queryForRowSet("select SumPrice , Beianeh from rqtitle where rqindex = ? and rqtype = ?", new Object[]{ConvertStr.decrypt((String)invoice.getErpcode()), invoice.getType()})).next()) {
                                                    oldPriceOrder = rs.getDouble("SumPrice");
                                                    oldBeianeh = rs.getDouble("Beianeh");
                                                }
                                                if (request.equals((Object)Request.PUT)) {
                                                    this.validationForEditAndDeleteFacture((JdbcTemplate)jdbcTemplate, invoice, invoiceType, FRegisterType);
                                                    this.deleteInvoice(myLogin, invoice, FRegisterType, request);
                                                }
                                                saleCostsActive = holder.enabledHazineInvoiceF != false && invoiceType.equals((Object)InvoiceType.SALE) != false;
                                                buyCostsActive = holder.enableKharidHazineh != false && invoiceType.equals((Object)InvoiceType.BUY) != false;
                                                avarezShahrdary = "";
                                                avarezAmozesh = "";
                                                switch (1.$SwitchMap$com$dao$InvoiceDao$InvoiceType[invoiceType.ordinal()]) {
                                                    case 1: {
                                                        avarezShahrdary = this.settingDao.getMSetup2String(myLogin, "SarAvarezK", "1070001");
                                                        avarezAmozesh = this.settingDao.getMSetup2String(myLogin, "SarMaliatK", "1070002");
                                                        break;
                                                    }
                                                    case 2: 
                                                    case 3: {
                                                        avarezShahrdary = this.settingDao.getMSetup2String(myLogin, "Vat_Sarfasl_Avarez", "");
                                                        avarezAmozesh = this.settingDao.getMSetup2String(myLogin, "Vat_Sarfasl_Maliat", "");
                                                        break;
                                                    }
                                                    case 4: {
                                                        avarezShahrdary = this.settingDao.getMSetup2String(myLogin, "SarAvarezRetK", "1070001");
                                                        avarezAmozesh = this.settingDao.getMSetup2String(myLogin, "SarMaliatRetK", "1070002");
                                                        break;
                                                    }
                                                    case 5: {
                                                        avarezShahrdary = this.settingDao.getMSetup2String(myLogin, "SarAvarezRetF", "");
                                                        avarezAmozesh = this.settingDao.getMSetup2String(myLogin, "SarMaliatRetF", "");
                                                        break;
                                                    }
                                                }
                                                vasetehPrice = 0.0;
                                                if (ConvertStr.isNullOrEmpty((String)invoice.getInputid())) {
                                                    throw new TncException(TncExceptionMessages.INVALID_ID);
                                                }
                                                if (!ConvertStr.isNullOrEmpty((String)invoice.getCustomrelation())) {
                                                    sqlStr = "Select C_Code From Customer where " + invoice.getCustomrelation() + "='" + invoice.getCustomererpcode() + "'";
                                                    rs = jdbcTemplate.queryForRowSet(sqlStr);
                                                    while (rs.next()) {
                                                        invoice.setCustomerid(rs.getString("C_Code"));
                                                    }
                                                } else if (!ConvertStr.isNullOrEmpty((String)invoice.getCustid())) {
                                                    invoice.setCustomerid(invoice.getCustid());
                                                } else if (!ConvertStr.isNullOrEmpty((String)invoice.getCustomererpcode())) {
                                                    invoice.setCustomerid(ConvertStr.decrypt((String)invoice.getCustomererpcode()));
                                                } else if (myLogin.getIsTorfehNegar().booleanValue() && !ConvertStr.isNullOrEmpty((String)invoice.getCustomernationalcode())) {
                                                    sqlStr = "Select TOP 1 C_CODE From CUSTOMER where NATIONAL_CODE = '" + invoice.getCustomernationalcode() + "' ORDER BY C_CODE ASC ";
                                                    rs = jdbcTemplate.queryForRowSet(sqlStr);
                                                    while (rs.next()) {
                                                        invoice.setCustomerid(rs.getString("C_CODE"));
                                                    }
                                                }
                                                if (ConvertStr.isNullOrEmpty((String)invoice.getCustomerid())) {
                                                    throw new TncException(TncExceptionMessages.INVALID_CUSTOMER_CODE);
                                                }
                                                if (!ConvertStr.isNullOrEmpty((String)invoice.getCustomerid()) && ConvertStr.isNullOrEmpty((String)invoice.getCustid())) {
                                                    sqlStr = "Select IsNull(Forosh,0) seller, IsNull(Kharid,0) buyer, C_Name \n From Customer where C_Code='" + invoice.getCustomerid() + "'";
                                                    invoiceIsBuyType = invoiceType.equals((Object)InvoiceType.BUY) != false || invoiceType.equals((Object)InvoiceType.RETURN_FROM_BUY) != false;
                                                    rs = jdbcTemplate.queryForRowSet(sqlStr);
                                                    if (!rs.next()) {
                                                        throw new TncException(TncExceptionMessages.INVALID_CUSTOMER_CODE);
                                                    }
                                                    if (this.isInvoiceOrPreInvoice(FRegisterType)) {
                                                        if (invoiceIsBuyType && !rs.getBoolean("seller")) {
                                                            throw new TncException(TncExceptionMessages.CUSTOMER_NOT_SELLER);
                                                        }
                                                        if (!invoiceIsBuyType && !rs.getBoolean("buyer")) {
                                                            throw new TncException(TncExceptionMessages.CUSTOMER_NOT_BUYER);
                                                        }
                                                    }
                                                    invoice.setCustomername(rs.getString("C_Name"));
                                                }
                                                if (ConvertStr.dateIsInvalid((String)invoice.getDate())) {
                                                    throw new TncException(TncExceptionMessages.INVALID_DATE);
                                                }
                                                if (ConvertStr.isNullOrEmpty((String)invoice.getTime()) != false) throw new TncException(TncExceptionMessages.INVALID_TIME);
                                                if (invoice.getTime().length() < 5) {
                                                    throw new TncException(TncExceptionMessages.INVALID_TIME);
                                                }
                                                if (ConvertStr.isNullOrEmpty((String)invoice.getComment())) {
                                                    invoice.setComment("");
                                                }
                                                if (ConvertStr.isNullOrEmpty((String)invoice.getMidmanerpcode())) {
                                                    invoice.setMidmanerpcode("");
                                                }
                                                if (!ConvertStr.isNullOrEmpty((String)invoice.getMidmanerpcode())) {
                                                    invoice.setMidmanerpcode(ConvertStr.decrypt((String)invoice.getMidmanerpcode()));
                                                    sqlStr = "SELECT COUNT(*) cnt FROM CUSTOMER  WHERE IsNull(vaseteh, 0) = 1 AND C_Code = '" + invoice.getMidmanerpcode() + "'";
                                                    rs = jdbcTemplate.queryForRowSet(sqlStr);
                                                    while (rs.next()) {
                                                        if (rs.getInt("cnt") != 0) continue;
                                                        throw new TncException(TncExceptionMessages.INVALID_MEDIATOR_ERP_CODE);
                                                    }
                                                }
                                                if (!myLogin.getIsMyHoloo().booleanValue() && !myLogin.getIsTorfehNegar().booleanValue()) {
                                                    sqlStr = "Select Sanad_Date From Sanad Where Sanad_Code = 1 AND sanad_state =1";
                                                    rs = jdbcTemplate.queryForRowSet(sqlStr);
                                                    if (rs.next() && Objects.requireNonNull(rs.getDate("Sanad_Date")).after(DateUtils.parseDate((String)invoice.getDate(), (String)DateUtils.defaultDateFormat.toPattern()))) {
                                                        throw new TncException(TncExceptionMessages.INVALID_BEFORE_DATE_OF_FACTURE);
                                                    }
                                                    sqlStr = "SELECT MAX(Sanad_Date) AS Sanad_Date, MAX(Sanad_Code_C) AS S_Code   FROM  Sanad WHERE End_Save  =  1";
                                                    rs = jdbcTemplate.queryForRowSet(sqlStr);
                                                    if (rs.next() && Objects.requireNonNull(rs.getDate("Sanad_Date")).after(DateUtils.parseDate((String)invoice.getDate(), (String)DateUtils.defaultDateFormat.toPattern()))) {
                                                        throw new TncException(TncExceptionMessages.INVALID_BEFORE_DATE_OF_FACTURE);
                                                    }
                                                }
                                                checkPayError = new CheckPayError(this.dbConnection, this.sarfaslDao);
                                                bank = invoice.getBank();
                                                if (invoice.getPosinfos() != null) {
                                                    for (Object posInfo : invoice.getPosinfos()) {
                                                        bank += posInfo.getBank();
                                                    }
                                                }
                                                if (this.isInvoice(FRegisterType)) {
                                                    idxErrorPay = checkPayError.checkErrorPay(invoice.getCash(), invoice.getCashsarfasl(), CheckPayError.SarfaslType.CASH, myLogin);
                                                    if (idxErrorPay.equals((Object)CheckPayError.PayErrorType.SARFASL_ERROR)) {
                                                        throw new TncException(TncExceptionMessages.INVALID_CASH_HEADING);
                                                    }
                                                    if (idxErrorPay.equals((Object)CheckPayError.PayErrorType.PRICE_ERROR)) {
                                                        throw new TncException(TncExceptionMessages.INVALID_CASH_AMOUNT);
                                                    }
                                                    idxErrorPay = checkPayError.checkErrorPay(invoice.getBank(), invoice.getBanksarfasl(), CheckPayError.SarfaslType.CARD, myLogin);
                                                    if (idxErrorPay.equals((Object)CheckPayError.PayErrorType.SARFASL_ERROR)) {
                                                        throw new TncException(TncExceptionMessages.INVALID_CARD_HEADING.setArgs(new Object[]{myLogin.getDatabaseName() + " - " + invoice.getBanksarfasl()}));
                                                    }
                                                    if (idxErrorPay.equals((Object)CheckPayError.PayErrorType.PRICE_ERROR)) {
                                                        throw new TncException(TncExceptionMessages.INVALID_CARD_AMOUNT);
                                                    }
                                                    if (invoice.getPosinfos() != null) {
                                                        posInfo = invoice.getPosinfos().iterator();
                                                        while (posInfo.hasNext()) {
                                                            posInfo = (InvoiceDto.PosInfo)posInfo.next();
                                                            idxErrorPay = checkPayError.checkErrorPay(posInfo.getBank(), posInfo.getBanksarfasl(), CheckPayError.SarfaslType.CARD, myLogin);
                                                            if (idxErrorPay.equals((Object)CheckPayError.PayErrorType.SARFASL_ERROR)) {
                                                                throw new TncException(TncExceptionMessages.INVALID_CARD_HEADING.setArgs(new Object[]{myLogin.getDatabaseName() + " - " + posInfo.getBanksarfasl()}));
                                                            }
                                                            if (!idxErrorPay.equals((Object)CheckPayError.PayErrorType.PRICE_ERROR)) continue;
                                                            throw new TncException(TncExceptionMessages.INVALID_CARD_AMOUNT);
                                                        }
                                                    }
                                                    if ((idxErrorPay = checkPayError.checkErrorPay(invoice.getNesiyeh(), "", CheckPayError.SarfaslType.NONE, myLogin)).equals((Object)CheckPayError.PayErrorType.PRICE_ERROR)) {
                                                        throw new TncException(TncExceptionMessages.INVALID_CREDIT_AMOUNT);
                                                    }
                                                    idxErrorPay = checkPayError.checkErrorPay(invoice.getDiscount(), "", CheckPayError.SarfaslType.NONE, myLogin);
                                                    if (idxErrorPay.equals((Object)CheckPayError.PayErrorType.PRICE_ERROR)) {
                                                        throw new TncException(TncExceptionMessages.INVALID_DISCOUNT_AMOUNT);
                                                    }
                                                }
                                                this.checkDuplicateWebId(myLogin, invoice.getInputid(), FRegisterType, invoiceType.getSymbol());
                                                if (!this.isOrder(FRegisterType)) break block262;
                                                sqlStr = "Select IsNull(Max(RqIndex2),0) + 1 RqIndex2 From RQTITLE";
                                                rs = jdbcTemplate.queryForRowSet(sqlStr);
                                                invoice.setCode(0);
                                                while (rs.next()) {
                                                    invoice.setCode(rs.getInt("RqIndex2"));
                                                }
                                                totalDiscount = this.calculateTotalDiscount(invoice);
                                                sqlStr = "Insert into RQTITLE(RqIndex2,RqType,R_CusCode,R_Date,T_Date,T_Time,SumPrice,Beianeh,fCard,fnaghd, UserName,ShowOrHide,vaseteh_code,Comment,WebId, FTakhfif) Values('" + invoice.getCode() + "','" + invoiceType.getSymbol() + "','" + invoice.getCustomerid() + "','" + invoice.getDate() + "','" + invoice.getDate() + "','" + invoice.getTime() + "',0, " + (invoice.getCash() + invoice.getBank()) + "," + invoice.getBank() + "," + invoice.getCash() + "," + (myLogin.getUserCodeInc() < 1 ? 1 : myLogin.getUserCodeInc()) + ", 1,'" + invoice.getMidmanerpcode() + "','" + invoice.getComment() + "','" + invoice.getInputid() + "'," + (totalDiscount == 0.0 ? null : Double.valueOf(totalDiscount)) + ")";
                                                jdbcTemplate.execute(sqlStr);
                                                sqlStr = "Select Max(RqIndex) RqIndex From RQTITLE";
                                                rs = jdbcTemplate.queryForRowSet(sqlStr);
                                                invoice.setId("0");
                                                while (rs.next()) {
                                                    invoice.setId(ConvertStr.getNullIfEmpty((String)rs.getString("RqIndex")));
                                                }
                                                if (!invoice.isWithdocument() || !(invoice.getCash() + invoice.getBank() > 0.0)) break block263;
                                                rs = jdbcTemplate.queryForRowSet(" Select SumPrice From RQTITLE  Where RqType ='" + invoiceType.getSymbol() + "' And RqIndex='" + invoice.getId() + "'");
                                                sumPrice = 0.0;
                                                while (rs.next()) {
                                                    sumPrice = rs.getDouble("SumPrice");
                                                }
                                                tableName = "rqTitle";
                                                factype = "rqType";
                                                facCode = "rqIndex";
                                                sanadCode = this.saveSanad(invoice, invoiceType, FRegisterType, myLogin, tableName, factype, facCode, sumPrice, 0.0, 0.0, holder, 0.0, 0.0, avarezShahrdary, avarezAmozesh, request, null);
                                                if (!myLogin.getIsMyHoloo().booleanValue()) {
                                                    beianeh = 0.0;
                                                    rs = jdbcTemplate.queryForRowSet("select Beianeh from rqtitle where rqindex = ? and rqtype = ?", new Object[]{invoice.getId(), invoice.getType()});
                                                    if (rs.next()) {
                                                        beianeh = rs.getDouble("Beianeh");
                                                    }
                                                    if (this.isOrder(FRegisterType) && invoice.getBank() + invoice.getCash() > 0.0 && oldBeianeh != beianeh) {
                                                        new ReceiveFromCustomerDao(this.dbConnection, myLogin, msg).insert((Object)invoice, request.equals((Object)Request.POST) != false ? ProcessDao.ProcessKind.ADD : ProcessDao.ProcessKind.EDIT);
                                                    }
                                                }
                                                break block263;
                                            }
                                            if (this.isPreInvoice(FRegisterType)) {
                                                sqlStr = this.settingDao.getMSetup2Boolean(myLogin, "MaxFac_Code_C") != false ? "SELECT ISNULL(MAX(FAC_CODE_C),0)+1 FAC_CODE_C FROM FBAILPRE WHERE FAC_TYPE='P'" : "SELECT ISNULL((SELECT TOP 1 FAC_CODE_C FROM FBAILPRE WHERE FAC_TYPE='P' ORDER BY FAC_CODE DESC, FAC_TYPE) , 0) + 1 FAC_CODE_C";
                                                rs = jdbcTemplate.queryForRowSet(sqlStr);
                                                invoice.setCode(0);
                                                while (rs.next()) {
                                                    invoice.setCode(rs.getInt("FAC_CODE_C"));
                                                }
                                                sqlStr = "Select dbo.produccode(Isnull(Max(Fac_Code),0)+1) Fac_Code From FbailPre Where Fac_Type='P'";
                                                rs = jdbcTemplate.queryForRowSet(sqlStr);
                                                invoice.setId("0");
                                                while (rs.next()) {
                                                    invoice.setId(ConvertStr.getNullIfEmpty((String)rs.getString("Fac_Code")));
                                                }
                                                if (!ConvertStr.isNullOrEmpty((String)invoice.getMidmanerpcode())) {
                                                    sqlStr = "Select Isnull(vaseteh_porsant,0) vasetehPrice From Customer Where C_Code='" + invoice.getMidmanerpcode() + "'";
                                                    rs = jdbcTemplate.queryForRowSet(sqlStr);
                                                    while (rs.next()) {
                                                        vasetehPrice = rs.getDouble("vasetehPrice");
                                                    }
                                                }
                                                sqlStr = "Insert into FbailPre(Sanad_Code,Fac_code,Fac_type,Fac_code_c,C_Code,Fac_Date,Fac_Time, Sum_price,vasetehCode,vasetehPrice,Takhfif,Fac_Comment,UserCode,WebId) Values('0','" + invoice.getId() + "','P'," + invoice.getCode() + ",'" + invoice.getCustomerid() + "','" + invoice.getDate() + "','" + invoice.getTime() + "',0,'" + invoice.getMidmanerpcode() + "'," + vasetehPrice + "," + invoice.getDiscount() + ",'" + invoice.getComment() + "'," + myLogin.getUserCodeInc() + ",'" + invoice.getInputid() + "')";
                                                jdbcTemplate.execute(sqlStr);
                                            } else if (this.isInvoice(FRegisterType)) {
                                                if (!myLogin.getIsMyHoloo().booleanValue()) {
                                                    if (invoice.getCode() <= 0) {
                                                        invoice.setCode(this.generateInvoiceCustomCode(myLogin, (JdbcTemplate)jdbcTemplate, invoiceType));
                                                    } else {
                                                        this.checkDuplicateInvoiceCustomCode(invoice.getCode(), invoice.getType(), (JdbcTemplate)jdbcTemplate);
                                                    }
                                                    if (myLogin.getIsTorfehNegar().booleanValue()) {
                                                        invoice.setId(this.getTorfehNegarInvCode(jdbcTemplate, invoiceType));
                                                    } else {
                                                        sqlStr = "Select dbo.produccode(Isnull(Max(Fac_Code), 0) + 1) Fac_Code From Facture Where Fac_Type='" + invoiceType.getSymbol() + "'";
                                                        rs = jdbcTemplate.queryForRowSet(sqlStr);
                                                        invoice.setId("0");
                                                        while (rs.next()) {
                                                            invoice.setId(ConvertStr.getNullIfEmpty((String)rs.getString("Fac_Code")));
                                                        }
                                                    }
                                                    if (!ConvertStr.isNullOrEmpty((String)invoice.getMidmanerpcode())) {
                                                        sqlStr = "Select Isnull(vaseteh_porsant,0) vasetehPrice From Customer Where C_Code='" + invoice.getMidmanerpcode() + "'";
                                                        rs = jdbcTemplate.queryForRowSet(sqlStr);
                                                        while (rs.next()) {
                                                            vasetehPrice = rs.getDouble("vasetehPrice");
                                                        }
                                                    }
                                                    hlpFieldL = invoice.getNesiyeh() != 0.0 ? 0 : 1;
                                                    sumCust = 0.0;
                                                    if (invoice.getCheckinfo() != null) {
                                                        for (CheckDto checkDto : ((PaymentDto)invoice.getCheckinfo().get(0)).getChecks()) {
                                                            sumCust += checkDto.getCust().doubleValue();
                                                        }
                                                    }
                                                    if ((affectedRow = jdbcTemplate.update(sqlStr = "Insert into Facture(Fac_code,Fac_type,Fac_code_c,C_Code,Fac_Date,Fac_Time,Sum_price,FNaghd,FCheck,FNesieh,TasviehDate,Takhfif,UserCode,HlpFieldL,DCEghtesad,DMaliat,HazFactK,DateUser,TimeUser,[Card],Kind_Vat,Fac_Comment,WebId,IsCms, RetFacCode) Values('" + invoice.getId() + "','" + invoiceType.getSymbol() + "'," + invoice.getCode() + ",'" + invoice.getCustomerid() + "','" + invoice.getDate() + "','" + invoice.getTime() + "',0," + invoice.getCash() + "," + sumCust + "," + invoice.getNesiyeh() + ",'" + (invoice.getTasviehdate() != null && invoice.getTasviehdate().isEmpty() == false ? invoice.getTasviehdate() : invoice.getDate()) + "'," + invoice.getDiscount() + "," + myLogin.getUserCodeInc() + "," + hlpFieldL + ",0,0,0,'" + invoice.getDate() + "','" + invoice.getTime() + "'," + bank + "," + holder.kindVAT + ",'" + invoice.getComment() + "','" + invoice.getInputid() + "'," + ConvertStr.getBoolToInt((Boolean)myLogin.getIsTorfehNegar()) + "," + ConvertStr.toQuotedSqlStr((String)invoice.getRetfaccode()) + ")")) == 0) {
                                                        throw new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
                                                    }
                                                } else {
                                                    sqlStr = "Insert into TmpFacture(FType, C_Code, C_CodeVaseteh, FDateTime, FNaghd, FNaghdSarfasl, FCard, FCardSarfasl, Takhfif, FNesiyeh, Comment, Kind, WebId, C_Code_C) Values('" + invoiceType.getSymbol() + "',";
                                                    sqlStr = ConvertStr.isNullOrEmpty((String)invoice.getCustid()) != false ? sqlStr + "'" + invoice.getCustomerid() + "'," : sqlStr + "'',";
                                                    sqlStr = sqlStr + "'" + invoice.getMidmanerpcode() + "','" + invoice.getDate() + " " + invoice.getTime() + "'," + invoice.getCash() + "," + ConvertStr.toQuotedSqlStr((String)invoice.getCashsarfasl()) + "," + invoice.getBank() + "," + ConvertStr.toQuotedSqlStr((String)invoice.getBanksarfasl()) + "," + invoice.getDiscount() + "," + invoice.getNesiyeh() + ",'" + invoice.getComment() + "'," + invoice.getKind() + ",'" + invoice.getInputid() + "','" + invoice.getCustid() + "')";
                                                    affectedRow = jdbcTemplate.update(sqlStr);
                                                    invoice.setId(null);
                                                    rs = jdbcTemplate.queryForRowSet(" Select SCOPE_IDENTITY() id ");
                                                    while (rs.next()) {
                                                        invoice.setId(rs.getString("id"));
                                                    }
                                                    if (invoice.getId() == null || invoice.getId().equals("0")) {
                                                        this.log.info(myLogin.getDatabaseName() + "$$$ TmpFacture Id is null = " + invoice.getId());
                                                        rs = jdbcTemplate.queryForRowSet(" SELECT MAX(Id) id FROM TMPFACTURE");
                                                        if (rs.next()) {
                                                            invoice.setId(rs.getString("id"));
                                                        }
                                                    }
                                                    if (ConvertStr.isNullOrEmpty((String)invoice.getId()) || affectedRow == 0) {
                                                        this.log.info(myLogin.getDatabaseName() + "$$$ TmpFacture error: id = " + invoice.getId() + " - affectedRows = " + affectedRow);
                                                        throw new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
                                                    }
                                                }
                                            }
                                        }
                                        if (!myLogin.getIsMyHoloo().booleanValue()) {
                                            this.insertCustomerAddress((JdbcTemplate)jdbcTemplate, invoice);
                                        }
                                        proxyServiceSupplier = (Supplier<ProxyInvoiceService>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$postInvoice$2(com.dto.LoginDto ), ()Lcom/service/invoice/ProxyInvoiceService;)((InvoiceDao)this, (LoginDto)myLogin);
                                        j = 0;
lbl304:
                                        // 2 sources

                                        while (true) {
                                            if (j < invoice.getDetailinfo().size()) {
                                                dtl = (InvoiceDetailDto)invoice.getDetailinfo().get(j);
                                                dtl.setInputid(dtl.getId());
                                                if (dtl.getLevy() == null) {
                                                    dtl.setLevy(Double.valueOf(0.0));
                                                }
                                                if (dtl.getScot() == null) {
                                                    dtl.setScot(Double.valueOf(0.0));
                                                }
                                                if (myLogin.getIsTorfehNegar().booleanValue() && dtl.getCmsid() == null) {
                                                    throw new TncException(TncExceptionMessages.INVALID_PRODUCT_CODE);
                                                }
                                                if (!ConvertStr.isNullOrEmpty((String)dtl.getCustomrelation())) {
                                                    sqlStr = "Select A_Code From Article where " + dtl.getCustomrelation() + "=" + dtl.getProducterpcode();
                                                    rs = jdbcTemplate.queryForRowSet(sqlStr);
                                                    while (rs.next()) {
                                                        dtl.setProductid(rs.getString("A_Code"));
                                                    }
                                                } else if (!myLogin.getIsMyHoloo().booleanValue() && !ConvertStr.isNullOrEmpty((String)dtl.getProducterpcode()) || myLogin.getIsMyHoloo().booleanValue() && ConvertStr.isNullOrEmpty((String)dtl.getProductid())) {
                                                    dtl.setProductid(ConvertStr.decrypt((String)dtl.getProducterpcode()));
                                                } else if (myLogin.getIsTorfehNegar().booleanValue()) {
                                                    sqlStr = "Select A_Code From Article where cms_id = " + dtl.getCmsid();
                                                    rs = jdbcTemplate.queryForRowSet(sqlStr);
                                                    while (rs.next()) {
                                                        dtl.setProductid(rs.getString("A_Code"));
                                                    }
                                                }
                                                if (ConvertStr.isNullOrEmpty((String)dtl.getProductid())) {
                                                    errorProductCode = dtl.getProductid();
                                                    throw new TncException(TncExceptionMessages.INVALID_PRODUCT_CODE);
                                                }
                                                if (ConvertStr.isNullOrEmpty((String)dtl.getComment())) {
                                                    dtl.setComment("");
                                                }
                                                sqlStr = "Select Count(*) cnt From Article where A_Code = ?";
                                                affectedRow = rs = jdbcTemplate.queryForRowSet(sqlStr, new Object[]{dtl.getProductid()}, new int[]{12});
                                                // MONITORENTER : rs
                                                if (rs.next() && rs.getInt("cnt") == 0) {
                                                    errorProductCode = dtl.getProductid();
                                                    throw new TncException(TncExceptionMessages.INVALID_PRODUCT_CODE);
                                                }
                                                // MONITOREXIT : affectedRow
                                                if (dtl.getFew() == null) throw new TncException(TncExceptionMessages.INVALID_PRODUCT_AMOUNT);
                                                if (dtl.getFew() <= 0.0) {
                                                    throw new TncException(TncExceptionMessages.INVALID_PRODUCT_AMOUNT);
                                                }
                                                if (dtl.getKarton() != null && dtl.getKarton() < 0.0) {
                                                    throw new TncException(TncExceptionMessages.INVALID_PRODUCT_AMOUNT);
                                                }
                                                if (dtl.getPrice() != null && !myLogin.isComplimentaryActive() && dtl.getPrice() <= 0.0) {
                                                    throw new TncException(TncExceptionMessages.INVALID_PRODUCT_PRICE);
                                                }
                                                if (dtl.getLevy() != null && dtl.getLevy() < 0.0) {
                                                    throw new TncException(TncExceptionMessages.INVALID_LEVY_SCOT);
                                                }
                                                if (dtl.getScot() != null && dtl.getScot() < 0.0) {
                                                    throw new TncException(TncExceptionMessages.INVALID_LEVY_SCOT);
                                                }
                                                if (!holder.usedDarsadTakhfifSatri || dtl.getDiscountpercent() == null) {
                                                    dtl.setDiscountpercent(Double.valueOf(0.0));
                                                }
                                                if (holder.usedDarsadTakhfifSatri && dtl.getDiscountpercent() < 0.0) {
                                                    throw new TncException(TncExceptionMessages.INVALID_DISCOUNT_AMOUNT);
                                                }
                                                if (!holder.usedDarsadTakhfifRialy && !holder.usedPriceTakhfifSatri || dtl.getDiscountprice() == null) {
                                                    dtl.setDiscountprice(Double.valueOf(0.0));
                                                }
                                                if (holder.usedPriceTakhfifSatri) {
                                                    dtl.setPercentType(0);
                                                }
                                                if ((holder.usedDarsadTakhfifRialy || holder.usedPriceTakhfifSatri) && dtl.getDiscountprice() < 0.0) {
                                                    throw new TncException(TncExceptionMessages.INVALID_DISCOUNT_AMOUNT);
                                                }
                                                Unit_Few = 1.0;
                                                if (!holder.useUnit) {
                                                    dtl.setUnitid("0");
                                                }
                                                if (!ConvertStr.isNullOrEmpty((String)dtl.getUnitid()) && !dtl.getUnitid().equals("0")) {
                                                    dtl.setUnitid(ConvertStr.decrypt((String)dtl.getUnitid()));
                                                    sqlStr = "Select Isnull(unit_few,0) unit_few From Unit Where cast(Unit_Code as nvarchar(5))='" + dtl.getUnitid() + "'";
                                                    rs = jdbcTemplate.queryForRowSet(sqlStr);
                                                    Unit_Few = 0.0;
                                                    while (rs.next()) {
                                                        Unit_Few = rs.getDouble("unit_few");
                                                    }
                                                    if (Unit_Few == 0.0) {
                                                        throw new TncException(TncExceptionMessages.INVALID_UNIT_ERP_CODE);
                                                    }
                                                }
                                                if (ConvertStr.isNullOrEmpty((String)dtl.getUnitid())) {
                                                    dtl.setUnitid("0");
                                                }
                                                existProduct = 0.0;
                                                getExist = 0.0;
                                                if (myLogin.getIsMyHoloo().booleanValue()) break block257;
                                                facCode = "";
                                                tName = "";
                                                mNames = new StringBuilder();
                                                needToBuild = 0.0;
                                                sqlStr = "Select Exist, A_Name from Article where A_Code ='" + dtl.getProductid() + "'";
                                                rs = jdbcTemplate.queryForRowSet(sqlStr);
                                                while (rs.next()) {
                                                    existProduct = rs.getDouble("Exist");
                                                    tName = rs.getString("A_Name");
                                                }
                                                if ((!this.isInvoice(FRegisterType) || !invoice.getType().equals("F") && !invoice.getType().equals("X")) && (!this.isPreInvoice(FRegisterType) || !invoice.getType().equals("P") || !this.negativePishNotAllowed(holder.negativePish, invoice)) && (!this.isOrder(FRegisterType) || !invoice.getType().equals("F") || !this.negativeInvoiceNotAllowed(holder.negativeOrder, invoice))) break block257;
                                                sqlStr = holder.calcExistInFactByPFact != false ? "Select Exist from W_GetExistArticle where A_Code ='" + dtl.getProductid() + "'" : "Select Exist from W_ShowArticleForSearch_Big where A_Code ='" + dtl.getProductid() + "'";
                                                rs = jdbcTemplate.queryForRowSet(sqlStr);
                                                while (rs.next()) {
                                                    getExist = rs.getDouble("Exist");
                                                }
                                                buildArtQueries = new ArrayList<String>();
                                                if (Unit_Few * dtl.getFew() > getExist && !this.negativeInvoiceNotAllowed(holder.negativeFact, invoice) && holder.isAutoBuildArtEnable) {
                                                    formulaId = dtl.getFormulaid();
                                                    if (formulaId != null) {
                                                        articleACodeSql = "Select A_CODE From BildEnd Where ID = " + formulaId;
                                                        articleACodeRowSet = jdbcTemplate.queryForRowSet(articleACodeSql);
                                                        if (!articleACodeRowSet.next()) {
                                                            model = new LinkedHashMap<String, Object>();
                                                            model.put("ErpCode", dtl.getProducterpcode());
                                                            model.put("FormulaId", formulaId);
                                                            myProduct.add(model);
                                                            throw new TncException(TncExceptionMessages.WRONG_FORMULA_ID_FOR_ARTICLE);
                                                        }
                                                        articleACode = articleACodeRowSet.getString("A_Code");
                                                        if (!articleACode.equals(dtl.getProductid())) {
                                                            model = new LinkedHashMap<String, Object>();
                                                            model.put("ErpCode", dtl.getProducterpcode());
                                                            model.put("FormulaId", formulaId);
                                                            myProduct.add(model);
                                                            throw new TncException(TncExceptionMessages.WRONG_FORMULA_ID_FOR_ARTICLE);
                                                        }
                                                    }
                                                    formulaSql = "Select * From BildEnd Where A_Code = " + dtl.getProductid();
                                                    if (formulaId != null) {
                                                        formulaSql = formulaSql + " AND ID = " + formulaId;
                                                    }
                                                    formulaRowSet = jdbcTemplate.queryForRowSet(formulaSql);
                                                    p1 = 0.0f;
                                                    p2 = 0.0f;
                                                    p3 = 0.0f;
                                                    if (formulaRowSet.next()) {
                                                        if (formulaId == null) {
                                                            formulaId = formulaRowSet.getInt("ID");
                                                        }
                                                        p1 = formulaRowSet.getFloat("Price_Hazineh1");
                                                        p2 = formulaRowSet.getFloat("Price_Hazineh2");
                                                        p3 = formulaRowSet.getFloat("Price_Hazineh3");
                                                    }
                                                    if (formulaId == null || formulaId == -1) break block258;
                                                    needToBuild = Unit_Few * dtl.getFew() - getExist;
                                                    facCodeQuery = "Select dbo.produccode(Isnull(Max(Fac_Code), 0) + 1) Fac_Code From FAC_BILD";
                                                    facCodeRowSet = jdbcTemplate.queryForRowSet(facCodeQuery);
                                                    while (facCodeRowSet.next()) {
                                                        facCode = facCodeRowSet.getString("Fac_Code");
                                                    }
                                                    facCodeCQuery = "select isNull(MAX(Fac_Code_C), 0) fac_code_c from FAC_BILD";
                                                    facCodeCRowSet = jdbcTemplate.queryForRowSet(facCodeCQuery);
                                                    facCodeC = ConvertStr.produceCode((int)1, (int)6);
                                                    while (facCodeCRowSet.next()) {
                                                        code = facCodeCRowSet.getInt("fac_code_c") + 1;
                                                        facCodeC = ConvertStr.produceCode((int)code, (int)6);
                                                    }
                                                    getFormula = "select * from BILDAVAL WHERE FormulaID = " + formulaId;
                                                    artsInFormula = jdbcTemplate.queryForRowSet(getFormula);
                                                    comment = "\u062a\u0648\u0644\u064a\u062f \u062c\u0647\u062a ''" + invoice.getCustomername() + "'' \u0637\u064a \u0641\u0627\u0643\u062a\u0648\u0631 ''" + invoice.getCode() + "''";
                                                    mPriceBs = 0.0;
                                                    tPriceBs = 0.0;
                                                    aIndex = j;
                                                    formatterWithoutSeconds = DateTimeFormatter.ofPattern("HH:mm");
                                                    formatterWithSeconds = DateTimeFormatter.ofPattern("HH:mm:ss");
                                                    try {
                                                        time = LocalTime.parse(invoice.getTime(), formatterWithSeconds);
                                                    }
                                                    catch (Exception e) {
                                                        time = LocalTime.parse(invoice.getTime(), formatterWithoutSeconds);
                                                    }
                                                    buildTime = time.minusNanos(3000000L);
                                                    break block259;
                                                }
                                                if (Unit_Few * dtl.getFew() > getExist && this.negativeInvoiceNotAllowed(holder.negativeFact, invoice)) {
                                                    model = new LinkedHashMap<String, Object>();
                                                    model.put("ErpCode", dtl.getProducterpcode());
                                                    model.put("Few", getExist);
                                                    myProduct.add(model);
                                                    throw new TncException(TncExceptionMessages.BELOW_PRODUCTS_HAVE_NO_STORE);
                                                }
                                                break block258;
                                            }
                                            if (!ConvertStr.isNullOrEmpty((Collection)invoice.getHazineinfo()) && this.isInvoice(FRegisterType)) {
                                                if (saleCostsActive || buyCostsActive) {
                                                    invoice.setHazineinfo(this.expenseCalculator.getModifiedList(invoice, myLogin, checkPayError));
                                                } else {
                                                    if (invoiceType.equals((Object)InvoiceType.BUY) && holder.enabledSarshekanHazineh) {
                                                        throw new TncException(TncExceptionMessages.CANNOT_ADD_COST_TO_BUY_INVOICE_WITH_ELIMINATOR);
                                                    }
                                                    if (invoiceType.equals((Object)InvoiceType.BUY) != false) throw new TncException(TncExceptionMessages.ADDING_COST_FEATURE_IS_OFF);
                                                    if (invoiceType.equals((Object)InvoiceType.SALE) != false) throw new TncException(TncExceptionMessages.ADDING_COST_FEATURE_IS_OFF);
                                                    throw new TncException(TncExceptionMessages.COST_ONLY_AVAILABLE_IN_SALE_BUY_INVOICES);
                                                }
                                            }
                                            if (!ConvertStr.isNullOrEmpty((Collection)invoice.getIncomeinfo()) && this.isInvoice(FRegisterType)) {
                                                if (!saleCostsActive) {
                                                    if (buyCostsActive == false) throw new TncException(TncExceptionMessages.CANNOT_ADD_INCOME_TO_INVOICE);
                                                }
                                                invoice.setIncomeinfo(this.incomeCalculator.getModifiedList(invoice, myLogin, checkPayError));
                                            }
                                            if (invoice.getNesiyeh() != 0.0 && this.isInvoice(FRegisterType) && !myLogin.getIsMyHoloo().booleanValue() && (invoice.getTasviehdate() == null || invoice.getTasviehdate().isEmpty())) {
                                                if (settingLoader.isModatTasviehEnabled()) {
                                                    articleCalcDataList = new ArrayList<ArticleCalcData>();
                                                    break block260;
                                                }
                                                sqlStr = "SELECT MohlatTasvieh FROM Customer WHERE C_Code = '" + invoice.getCustomerid() + "'";
                                                rs = jdbcTemplate.queryForRowSet(sqlStr);
                                                if (rs.next() && (mohlatTasvieh = Double.valueOf(rs.getDouble("MohlatTasvieh"))) != null && mohlatTasvieh != 0.0) {
                                                    tasviehDate = InvoiceUtils.getXDaysLaterSinceDate((int)((int)InvoiceUtils.roundToWholeNumber((double)mohlatTasvieh)), (Date)DateUtils.parseDate((String)invoice.getDate(), (String)DateUtils.defaultDateFormat.toPattern()));
                                                    convertedDate = DateUtils.defaultDateTimeFormat.format(tasviehDate);
                                                    sqlStr = "UPDATE Facture SET TasviehDate='" + convertedDate + "' WHERE Fac_Code = '" + invoice.getId() + "'";
                                                    jdbcTemplate.execute(sqlStr);
                                                }
                                            }
lbl498:
                                            // 6 sources

                                            while (true) {
                                                block265: {
                                                    block267: {
                                                        block266: {
                                                            block264: {
                                                                if (!this.isOrder(FRegisterType)) break block264;
                                                                sqlStr = holder.useCountInUnitInPrice != false ? " Update Rqtitle Set Sumprice=(Select Round(Sum(R_few*R_cost*Isnull(Unit_few,1)),0)   From Rqdetail rq left join unit u on Isnull(rq.unit_code,0)=u.unit_code   where Rqindex='" + invoice.getId() + "')  Where RqIndex='" + invoice.getId() + "'" : "Update RQTITLE  Set SumPrice=(Select Round(Sum(R_Few*R_Cost),0) From RQDETAIL where RqIndex='" + invoice.getId() + "') Where RqIndex='" + invoice.getId() + "'";
                                                                jdbcTemplate.execute(sqlStr);
                                                                break block265;
                                                            }
                                                            if (!this.isPreInvoice(FRegisterType)) break block266;
                                                            sqlStr = "Update FBailPre  Set Sum_Price=(Select Round(Sum(Few_Article*Price_Bs),0) From AbailPre Where Fac_Type='P' And Fac_Code='" + invoice.getId() + "') Where Fac_Type='P' And Fac_Code='" + invoice.getId() + "'";
                                                            jdbcTemplate.execute(sqlStr);
                                                            if (vasetehPrice > 0.0) {
                                                                sqlStr = "Update FBailPre Set vasetehPrice=Round((Sum_Price * vasetehPrice)/100,0) \n Where Fac_Type='P' And Fac_Code='" + invoice.getId() + "'";
                                                                jdbcTemplate.execute(sqlStr);
                                                            }
                                                            break block265;
                                                        }
                                                        if (!this.isInvoice(FRegisterType)) break block265;
                                                        sqlStr = myLogin.getIsMyHoloo() == false ? "Update Facture  Set Sum_Price=(Select Round(Sum(ISNULL(Few_Article, 0) * ISNULL(Price_Bs, 0)), 0) From Factart  Where Fac_Type='" + invoiceType.getSymbol() + "' And Fac_Code='" + invoice.getId() + "') , Sum_Few=(Select Round(Sum(ISNULL(Few_Article, 0)),5) From Factart Where Fac_Type='" + invoiceType.getSymbol() + "' And Fac_Code='" + invoice.getId() + "') Where Fac_Type='" + invoiceType.getSymbol() + "' And Fac_Code='" + invoice.getId() + "'" : "Update TmpFacture  Set SumPrice=(Select Round(Sum(A_Few*A_Price), 0) From TmpFactart Where IDFacture=" + invoice.getId() + ") , SumFew=(Select Round(Sum(A_Few),5) From TmpFactart Where IDFacture=" + invoice.getId() + ") Where ID=" + invoice.getId();
                                                        affectedRows = jdbcTemplate.update(sqlStr);
                                                        if (affectedRows == 0) {
                                                            for (i = 0; i < 3; ++i) {
                                                                affectedRows = jdbcTemplate.update(sqlStr);
                                                                if (affectedRows <= 0) continue;
                                                            }
                                                            this.log.info(myLogin.getDatabaseName() + " - $$$ Update TmpFacture Tries: " + i + " - id = " + invoice.getId());
                                                        }
                                                        if (affectedRows == 0) {
                                                            this.log.info(myLogin.getDatabaseName() + "$$$ Update TmpFacture error: id = " + invoice.getId() + " - affectedRows = " + affectedRows);
                                                            throw new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
                                                        }
                                                        if (holder.kindVAT == 0) {
                                                            sqlStr = myLogin.getIsMyHoloo() == false ? "Update Facture  Set Sum_Levy=(Select Round(Sum(((Few_Article * Price_Bs) - (IsNull(TakhfifSatriR, 0) * Few_Article)  - (IsNull(DarsadTakhfif, 0) / 100 * (Few_Article * Price_Bs)))* Levy) / 100, 0) From Factart Where Fac_Type='" + invoiceType.getSymbol() + "' And Fac_Code='" + invoice.getId() + "'),  Sum_Scot=(Select Round(Sum(((Few_Article * Price_Bs) - (IsNull(TakhfifSatriR, 0) * Few_Article)  - (IsNull(DarsadTakhfif, 0) / 100 * (Few_Article * Price_Bs)))* Scot) / 100, 0)           From Factart Where Fac_Type='" + invoiceType.getSymbol() + "'           And Fac_Code='" + invoice.getId() + "') Where Fac_Type='" + invoiceType.getSymbol() + "' And Fac_Code='" + invoice.getId() + "'" : "Update TmpFacture  Set SumLevy=(Select Round(Sum(A_Few * A_Price * Levy) / 100, 0)  From TmpFactart Where IDFacture=" + invoice.getId() + "),  SumScot=(Select Round(Sum(A_Few * A_Price * Scot) / 100, 0)           From TmpFactart Where IDFacture=" + invoice.getId() + ") Where ID = " + invoice.getId();
                                                            jdbcTemplate.execute(sqlStr);
                                                        }
                                                        if (holder.kindVAT == 1) {
                                                            sqlStr = myLogin.getIsMyHoloo() == false ? "Update Facture  Set Sum_Levy=( Round((Sum_Price-Takhfif) * " + invoice.getLevy() + " / 100, 0)) ,   Sum_Scot=( Round((Sum_Price-Takhfif) * " + invoice.getScot() + " / 100, 0)) Where Fac_Type='" + invoiceType.getSymbol() + "' And Fac_Code='" + invoice.getId() + "'" : "Update TmpFacture  Set SumLevy=(Round((SumPrice-Takhfif) * " + invoice.getLevy() + " / 100, 0)) ,   SumScot=(Round((SumPrice-Takhfif) * " + invoice.getScot() + " / 100, 0)) Where ID=" + invoice.getId();
                                                            jdbcTemplate.execute(sqlStr);
                                                        }
                                                        if (!myLogin.getIsMyHoloo().booleanValue()) {
                                                            sqlStr = "Update Facture  Set DAmozesh = Sum_Levy , DShahrdary = Sum_Scot   , IsLevyAndScot = (Case When Sum_Levy+Sum_Scot > 0 then 1 else 0 end)  Where Fac_Type='" + invoiceType.getSymbol() + "' And Fac_Code='" + invoice.getId() + "'";
                                                            jdbcTemplate.execute(sqlStr);
                                                        }
                                                        SumFact = 0.0;
                                                        rs = myLogin.getIsMyHoloo() == false ? jdbcTemplate.queryForRowSet(" Select Sum_Price+Sum_Levy+Sum_Scot SumFact From Facture Where Fac_Type='" + invoiceType.getSymbol() + "' And Fac_Code='" + invoice.getId() + "'") : jdbcTemplate.queryForRowSet(" Select SumPrice+SumLevy+SumScot SumFact From TmpFacture Where [ID]=" + invoice.getId());
                                                        while (rs.next()) {
                                                            SumFact = rs.getDouble("SumFact");
                                                        }
                                                        sumOfAllCosts = 0.0;
                                                        sumOfSameCustomerHazineh = 0.0;
                                                        sumOfAllIncomes = 0.0;
                                                        sumOfSameCustomerIncome = 0.0;
                                                        if (invoice.getHazineinfo() != null && (saleCostsActive || buyCostsActive)) {
                                                            sumOfAllCosts = this.expenseCalculator.getSumOfAllPrices(invoice);
                                                            sumOfSameCustomerHazineh = this.expenseCalculator.getSumOfInvoiceCustomerPrices(invoice);
                                                        }
                                                        if (invoice.getIncomeinfo() != null && (saleCostsActive || buyCostsActive)) {
                                                            sumOfAllIncomes = this.incomeCalculator.getSumOfAllPrices(invoice);
                                                            sumOfSameCustomerIncome = this.incomeCalculator.getSumOfInvoiceCustomerPrices(invoice);
                                                        }
                                                        sumOfPayments = invoice.getCash() + bank + invoice.getNesiyeh() + invoice.getDiscount() + (invoice.getCheckinfo() != null ? invoice.getSumcheck() : 0.0);
                                                        if (invoiceType.equals((Object)InvoiceType.SALE)) {
                                                            SumFact -= sumOfSameCustomerHazineh;
                                                            SumFact += sumOfSameCustomerIncome;
                                                        } else if (invoiceType.equals((Object)InvoiceType.BUY)) {
                                                            SumFact += sumOfSameCustomerHazineh;
                                                            SumFact -= sumOfSameCustomerIncome;
                                                        }
                                                        if (!myLogin.getIsTorfehNegar().booleanValue()) {
                                                            if (sumOfPayments != SumFact) {
                                                                this.log.info(myLogin.getDatabaseName() + " Sums-Exception webId = " + invoice.getInputid() + " - id = " + invoice.getId() + " - sumOfPayments = " + sumOfPayments + " - sumFact = " + SumFact);
                                                                throw new TncException(TncExceptionMessages.UNEVEN_PAY_AND_TO_PAY_PRICES);
                                                            }
                                                        } else {
                                                            difference = SumFact - sumOfPayments;
                                                            if (sumOfPayments != SumFact && Math.abs(difference) > 2.0 || (invoice.getCash() > 0.0 || invoice.getNesiyeh() == 0.0 && bank == 0.0) && sumOfPayments != SumFact) {
                                                                this.log.info(myLogin.getDatabaseName() + " Sums-Exception webId = " + invoice.getInputid() + " - id = " + invoice.getId() + " - sumOfPayments = " + sumOfPayments + " - sumFact = " + SumFact);
                                                                throw new TncException(TncExceptionMessages.UNEVEN_PAY_AND_TO_PAY_PRICES);
                                                            }
                                                            if (Math.abs(difference) <= 2.0 && sumOfPayments != SumFact) {
                                                                if (invoice.getNesiyeh() <= 0.0 && bank > 0.0) {
                                                                    jdbcTemplate.update(" UPDATE FACTURE SET CARD = ? WHERE  FAC_CODE = ? AND FAC_TYPE = ?", new Object[]{bank += difference, invoice.getId(), invoiceType.getSymbol()});
                                                                } else if (bank <= 0.0 && invoice.getNesiyeh() > 0.0) {
                                                                    invoice.setNesiyeh(invoice.getNesiyeh() + difference);
                                                                    jdbcTemplate.update(" UPDATE FACTURE SET FNESIEH = ? WHERE  FAC_CODE = ? AND FAC_TYPE = ?", new Object[]{invoice.getNesiyeh(), invoice.getId(), invoiceType.getSymbol()});
                                                                }
                                                            }
                                                        }
                                                        invoice.setSumprice(SumFact);
                                                        rs = myLogin.getIsMyHoloo() == false ? jdbcTemplate.queryForRowSet(" Select Sum(Isnull(TakhfifSatriR,0)) TakhfifSatriR,Sum((Few_Article * Price_Bs * Isnull(DarsadTakhfif,0))/100) DarsadTakhfif From Factart Where Fac_Type='" + invoiceType.getSymbol() + "' And Fac_Code='" + invoice.getId() + "'") : jdbcTemplate.queryForRowSet(" Select Sum(Isnull(TakhfifSatriR,0)) TakhfifSatriR,Sum((A_FEW * A_PRICE * Isnull(DarsadTakhfif,0))/100) DarsadTakhfif From TMPFACTART Where IDFACTURE='" + invoice.getId() + "'");
                                                        discountSatriR = 0.0;
                                                        while (rs.next()) {
                                                            if (rs.getDouble("TakhfifSatriR") > 0.0) {
                                                                discountSatriR = rs.getDouble("TakhfifSatriR");
                                                                continue;
                                                            }
                                                            discountSatriR = rs.getDouble("DarsadTakhfif");
                                                        }
                                                        if (invoice.getDiscount() < discountSatriR) {
                                                            throw new TncException(TncExceptionMessages.UNEVEN_TOTAL_DISCOUNT_AND_DTL_SUM_DISCOUNT);
                                                        }
                                                        if (myLogin.getIsMyHoloo().booleanValue()) break block265;
                                                        if (invoice.getVaseteh() == null) break block267;
                                                        for (InvoiceVasetehDto vasetehDto : invoice.getVaseteh()) {
                                                            block269: {
                                                                block268: {
                                                                    vasetehPorsant = 0.0;
                                                                    rs2 = jdbcTemplate.queryForRowSet("select Vaseteh_Porsant from CustomerVaseteh where c_code = ? ", new Object[]{ConvertStr.decrypt((String)vasetehDto.getMidmanerpcode())});
                                                                    if (rs2.next()) {
                                                                        vasetehPorsant = rs2.getFloat("Vaseteh_Porsant");
                                                                    } else {
                                                                        rs2 = jdbcTemplate.queryForRowSet("select Vaseteh_Porsant from Customer where c_code = ? ", new Object[]{ConvertStr.decrypt((String)vasetehDto.getMidmanerpcode())});
                                                                        if (rs2.next()) {
                                                                            vasetehPorsant = rs2.getFloat("Vaseteh_Porsant");
                                                                        }
                                                                    }
                                                                    sumPorsantVaseteh = vasetehPorsant * invoice.getSumprice() / 100.0;
                                                                    if (!settingLoader.isSlctMoreThan1Vaseteh()) break block268;
                                                                    if (vasetehDto.getMidmancommissionpercent() > 0.0) {
                                                                        vasetehPorsant = vasetehDto.getMidmancommissionpercent();
                                                                        sumPorsantVaseteh = vasetehPorsant * invoice.getSumprice() / 100.0;
                                                                        break block269;
                                                                    } else if (vasetehDto.getMidmantotalcommission() > 0.0) {
                                                                        sumPorsantVaseteh = vasetehDto.getMidmantotalcommission();
                                                                        vasetehPorsant = 0.0;
                                                                    }
                                                                    break block269;
                                                                }
                                                                if (vasetehDto.getMidmantotalcommission() > 0.0) {
                                                                    sumPorsantVaseteh = vasetehDto.getMidmantotalcommission();
                                                                }
                                                            }
                                                            hazienh = this.settingDao.getMSetup2String(myLogin, "HazVaseteh", null);
                                                            jdbcTemplate.update(" insert into FCOUNECT (fac_code,fac_type,sanad_code, Darsad_Porsunt,Cust_Porsunt,Counect_Code,c_code,SarFasl_Code) values (?,?,?,?,?,?,?,?) ", new Object[]{invoice.getId(), invoice.getType(), sanadCode, vasetehPorsant, sumPorsantVaseteh, ConvertStr.decrypt((String)vasetehDto.getMidmanerpcode()), invoice.getCustomerid(), settingLoader.SaveCustForVaseteh() == false ? null : (vasetehDto.getSarfaslcodehazineh() != null ? vasetehDto.getSarfaslcodehazineh() : hazienh)});
                                                        }
                                                    }
                                                    if (!(rs = jdbcTemplate.queryForRowSet(" Select Sum_Price, Sum_Levy, Sum_Scot From Facture  Where Fac_Type='" + invoiceType.getSymbol() + "' And Fac_Code='" + invoice.getId() + "'")).next()) {
                                                        throw new TncException(TncExceptionMessages.FACTURE_NOT_FOUNDED_TO_ADD_SANAD.setArgs(new Object[]{invoice.getId(), invoiceType.getSymbol()}));
                                                    }
                                                    sumPrice = rs.getDouble("Sum_Price");
                                                    sumLevy = rs.getDouble("Sum_Levy");
                                                    sumScot = rs.getDouble("Sum_Scot");
                                                    tableName = "facture";
                                                    facType = "Fac_Type";
                                                    facCode = "Fac_Code";
                                                    if (invoice.getCheckinfo() != null) {
                                                        for (PaymentDto paymentDto : invoice.getCheckinfo()) {
                                                            paymentDto.setCustomerCode(invoice.getCustomerid());
                                                            if (invoice.getInvoiceType().getSymbol().equalsIgnoreCase("F") || invoice.getInvoiceType().getSymbol().equalsIgnoreCase("Y")) {
                                                                paymentDto.setSanadtype(4);
                                                            } else if (invoice.getInvoiceType().getSymbol().equalsIgnoreCase("K") || invoice.getInvoiceType().getSymbol().equalsIgnoreCase("X")) {
                                                                paymentDto.setSanadtype(5);
                                                            }
                                                            checkDao.findCheckErrors(paymentDto);
                                                            checkDao.insertChecks(paymentDto);
                                                        }
                                                    }
                                                    if (this.isInvoice(FRegisterType)) {
                                                        sanadCode = this.saveSanad(invoice, invoiceType, FRegisterType, myLogin, tableName, facType, facCode, sumPrice, sumLevy, sumScot, holder, sumOfAllIncomes, sumOfAllCosts, avarezShahrdary, avarezAmozesh, request, Integer.valueOf(invoice.getCode()));
                                                    }
                                                    if (invoice.getCheckinfo() != null) {
                                                        for (CheckDto check : ((PaymentDto)invoice.getCheckinfo().get(0)).getChecks()) {
                                                            jdbcTemplate.update("update [Check] set sanad_code = ? where check_code = ? ", new Object[]{sanadCode, check.getCheckcode()});
                                                            jdbcTemplate.update("update [Check_Event]  set sanad_code = ? where  check_code = ? and state = ? ", new Object[]{sanadCode, check.getCheckcode(), "'" + check.getState() + "'"});
                                                            jdbcTemplate.update("update [CHECK_BKUP] set sanad_code = ? where Check_Number = ? and sanad_code = 0  ", new Object[]{sanadCode, check.getChecknumber()});
                                                            jdbcTemplate.update("update [SND_INDX]  set sanad_code = ? , fac_code = ? , fac_type = ? where Check_Code = ? and sanad_code = 0", new Object[]{sanadCode, invoice.getId(), invoice.getType(), check.getCheckcode()});
                                                        }
                                                        checkCodes = new ArrayList<String>();
                                                        sumFewCheck = 0.0;
                                                        for (CheckDto checkDto : ((PaymentDto)invoice.getCheckinfo().get(0)).getChecks()) {
                                                            sumFewCheck += checkDto.getCust().doubleValue();
                                                            checkCodes.add(String.valueOf(checkDto.getChecknumber()));
                                                        }
                                                        if (invoice.getSumcheck() != sumFewCheck && invoice.getSumprice() == invoice.getSumcheck()) {
                                                            throw new TncException(TncExceptionMessages.UNEVEN_PAY_AND_TO_PAY_PRICES);
                                                        }
                                                        if (invoice.getSumcheck() > 0.0 && invoice.getSumcheck() != sumFewCheck) {
                                                            throw new TncException(TncExceptionMessages.INVALID_SUM_CHECK);
                                                        }
                                                        comment = checkDao.makeComment(checkCodes, invoice.getType().equals("F") != false || invoice.getType().equals("P") != false);
                                                        if (comment != null) {
                                                            jdbcTemplate.update(" UPDATE SANAD SET COMMENT = " + ConvertStr.toQuotedSqlStr((String)comment) + " WHERE SANAD_CODE = ?", new Object[]{sanadCode});
                                                        }
                                                    }
                                                }
                                                if (this.isOrderOrInvoice(FRegisterType) && !myLogin.getIsMyHoloo().booleanValue()) {
                                                    this.serialOperations(invoice, myLogin);
                                                }
                                                if (!myLogin.getIsMyHoloo().booleanValue()) {
                                                    invoice.setRegisterType(FRegisterType);
                                                    invoice.setSanadcode(sanadCode);
                                                    if (!ConvertStr.isNullOrEmpty((Collection)invoice.getCheckinfo()) && invoice.getCheckinfo().size() > 0 && this.isInvoice(FRegisterType) && request.equals((Object)Request.POST)) {
                                                        new ReceiveFromCustomerDao(this.dbConnection, myLogin, msg).insert((Object)invoice, ProcessDao.ProcessKind.ADD);
                                                    }
                                                    if (this.isInvoice(FRegisterType)) {
                                                        new InvoiceProcessDao(this.dbConnection, myLogin, msg).insert((Object)invoice, request.equals((Object)Request.POST) != false ? ProcessDao.ProcessKind.ADD : ProcessDao.ProcessKind.EDIT);
                                                    }
                                                }
                                                if (this.isInvoice(FRegisterType) && sanadCode <= 0 && !myLogin.getIsMyHoloo().booleanValue()) {
                                                    throw new Exception("\u062f\u0631 \u062f\u0631\u062c \u0633\u0646\u062f \u0645\u0634\u06a9\u0644\u06cc \u067e\u06cc\u0634 \u0622\u0645\u062f\u0647 \u0648 \u0641\u0627\u06a9\u062a\u0648\u0631 \u062b\u0628\u062a \u0646\u0634\u062f. \u0644\u0637\u0641\u0627 \u0645\u062c\u062f\u062f \u062a\u0644\u0627\u0634 \u0646\u0645\u0627\u06cc\u06cc\u062f");
                                                }
                                                if (!myLogin.getIsMyHoloo().booleanValue() && this.isOrder(FRegisterType)) {
                                                    rs = jdbcTemplate.queryForRowSet("select c_name from Customer where c_code = ?", new Object[]{ConvertStr.decrypt((String)invoice.getCustomererpcode())});
                                                    if (rs.next()) {
                                                        invoice.setCustomername(rs.getString("c_name"));
                                                    }
                                                    invoice.setCustomerid(ConvertStr.decrypt((String)invoice.getCustomererpcode()));
                                                    new OrderProcessDao(this.dbConnection, myLogin, msg, oldPriceOrder).insert((Object)invoice, request.equals((Object)Request.POST) != false ? ProcessDao.ProcessKind.ADD : ProcessDao.ProcessKind.EDIT);
                                                }
                                                model = new LinkedHashMap<String, String>();
                                                if (!ConvertStr.isNullOrEmpty((String)invoice.getInputid())) {
                                                    model.put("Id", invoice.getInputid());
                                                }
                                                model.put("ErpCode", ConvertStr.encrypt((String)invoice.getId()));
                                                model.put("Code", String.valueOf(invoice.getCode()));
                                                if (this.isInvoice(FRegisterType)) {
                                                    model.put("SanadCode", String.valueOf(sanadCode));
                                                }
                                                if (myLogin.getIsMyHoloo().booleanValue()) {
                                                    model.put("Dbname", myLogin.getDatabaseName().substring(myLogin.getDatabaseName().indexOf("[") + 1, myLogin.getDatabaseName().lastIndexOf("]")));
                                                }
                                                if (myLogin.getIsTorfehNegar().booleanValue() && invoiceType.getSymbol().equals("O") && invoice.getCmsidf() != null && !invoice.getCmsidf().equals(0L)) {
                                                    gson = new Gson();
                                                    price = invoice.getDetailinfo().stream().mapToDouble((ToDoubleFunction<InvoiceDetailDto>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)D, lambda$postInvoice$3(com.dto.InvoiceDetailDto ), (Lcom/dto/InvoiceDetailDto;)D)()).sum();
                                                    invoiceDetailDto = new InvoiceDetailDto();
                                                    invoiceDetailDto.setId("0");
                                                    invoiceDetailDto.setCmsid(invoice.getCmsidf());
                                                    invoiceDetailDto.setFew(Double.valueOf(1.0));
                                                    invoiceDetailDto.setPrice(Double.valueOf(Math.round(price)));
                                                    invoiceDetailDto.setLevy(Double.valueOf(0.0));
                                                    invoiceDetailDto.setComment(String.valueOf(invoice.getCode()));
                                                    sellerNationalCode = ((InvoiceDetailDto)invoice.getDetailinfo().get(0)).getSellernationalcode();
                                                    invoiceCopy = new InvoiceDto.InvoiceInfo();
                                                    invoiceCopy.setId(invoice.getInputid());
                                                    invoiceCopy.setType("1");
                                                    invoiceCopy.setCustomernationalcode(sellerNationalCode);
                                                    invoiceCopy.setDate(invoice.getDate());
                                                    invoiceCopy.setTime(invoice.getTime());
                                                    invoiceCopy.setCommissiontax(invoice.getCommissiontax());
                                                    invoiceCopy.setLevy(invoice.getLevy());
                                                    invoiceCopy.setNesiyeh(invoiceDetailDto.getPrice() + (double)Math.round(invoice.getLevy() * invoiceDetailDto.getPrice() / 100.0));
                                                    invoiceCopy.setComment(String.valueOf(invoice.getCode()));
                                                    detailList = new ArrayList<InvoiceDetailDto>();
                                                    detailList.add(invoiceDetailDto);
                                                    invoiceCopy.setDetailinfo(detailList);
                                                    toPost = new ArrayList<InvoiceDto.InvoiceInfo>();
                                                    toPost.add(invoiceCopy);
                                                    map = new HashMap<String, ArrayList<InvoiceDto.InvoiceInfo>>();
                                                    map.put("Invoiceinfo", toPost);
                                                    responseEntity = this.postInvoice(gson.toJson(map), 2, rebuildJson, myLogin, true, request);
                                                    successResponse = (Map)((Map)responseEntity.getBody()).get("Success");
                                                    sqlStr = "UPDATE FACTART SET ConvertState = '" + successResponse.get("SanadCode").toString() + "' WHERE Fac_Type = 'O' AND Fac_Code = '" + ConvertStr.decrypt((String)model.get("ErpCode").toString()) + "'";
                                                    jdbcTemplate.execute(sqlStr);
                                                }
                                                success.add(model);
                                                if (!myLogin.getIsMyHoloo().booleanValue()) continue block18;
                                                this.log.info(myLogin.getDatabaseName() + " *** InvInsSuccess: " + model.toString());
                                                continue block18;
                                                break;
                                            }
                                            break;
                                        }
                                    }
                                    catch (TncException tncEx) {
                                        if (isInLoop) {
                                            throw tncEx;
                                        }
                                        if (!ConvertStr.isNullOrEmpty((String)invoice.getInputid())) {
                                            tncEx.putMoreInfo("Id", (Object)invoice.getInputid());
                                        }
                                        if (!myProduct.isEmpty()) {
                                            if (myProduct.size() == 1) {
                                                tncEx.putMoreInfo("ProductDetail", myProduct.get(0));
                                            } else {
                                                tncEx.putMoreInfo("ProductDetail", myProduct);
                                            }
                                        }
                                        if (myLogin.getIsMyHoloo().booleanValue()) {
                                            tncEx.putMoreInfo("Dbname", (Object)jdbcTemplate.getLogin().getDatabaseName().substring(myLogin.getDatabaseName().indexOf("[") + 1, myLogin.getDatabaseName().lastIndexOf("]")));
                                            this.log.info(myLogin.getDatabaseName() + " *** InvInsTncErr: " + tncEx.getErrorMap());
                                        }
                                        failure.add(tncEx.getErrorMap());
                                        errorLog = "dbname: " + myLogin.getDatabaseName() + " Exception *** message: " + tncEx.getMessage();
                                        if (errorProductCode != null) {
                                            errorLog = errorLog + " Error A_CODE: " + errorProductCode;
                                        }
                                        this.log.info(errorLog);
                                        exceptions.add(tncEx);
                                    }
                                }
                            }
                            catch (Throwable ex) {
                                e = new TncException(TncExceptionMessages.DEFAULT_ERROR);
                                if (myLogin.getIsTorfehNegar().booleanValue()) {
                                    e.putMoreInfo("ErrorMessage", (Object)ex.getMessage());
                                }
                                if (myLogin.getIsMyHoloo().booleanValue()) {
                                    e.putMoreInfo("Dbname", (Object)myLogin.getDatabaseName().substring(myLogin.getDatabaseName().indexOf("[") + 1, myLogin.getDatabaseName().lastIndexOf("]")));
                                    this.log.info(myLogin.getDatabaseName() + " *** InvInsErr: " + e.getErrorMap());
                                }
                                failure.add(e.getErrorMap());
                                this.log.info("dbname: " + myLogin.getDatabaseName() + "Exception *** message: " + e.getMessage() + " exception message : " + (myLogin.getIsTorfehNegar() == false ? ex.getMessage() : "\n" + ex.getCause() + Arrays.toString(ex.getStackTrace())));
                                exceptions.add(e);
                                if (!isInLoop) break block261;
                                throw ex;
                            }
                        }
                        if (exceptions.isEmpty() != false) return ConvertStr.getMapResponseEntity((String)"Invoice", failure, success);
                        if (isInLoop != false) return ConvertStr.getMapResponseEntity((String)"Invoice", failure, success);
                        throw new TncException(exceptions).addSuccessList(success);
                    }
                    while (artsInFormula.next()) {
                        ++aIndex;
                        if (dtl.getAindex() != null) {
                            aIndex = dtl.getAindex();
                        }
                        needToUse = artsInFormula.getDouble("Few") * needToBuild;
                        exist = 0.0;
                        karton = 0.0;
                        materialQuery = "select A_Name, isNull(Buy_Price, 0) priceBs, isNull(karton, 0) karton, isNull(exist, 0) exist from ARTICLE where A_Code = " + artsInFormula.getString("A_Code");
                        materialRowSet = jdbcTemplate.queryForRowSet(materialQuery);
                        if (materialRowSet.next()) {
                            mPriceBs = materialRowSet.getDouble("priceBs");
                            karton = materialRowSet.getDouble("karton");
                            exist = materialRowSet.getDouble("exist");
                            if (mNames.length() == 0) {
                                mNames.append(materialRowSet.getString("A_Name"));
                            } else {
                                mNames.append(", ").append(materialRowSet.getString("A_Name"));
                            }
                        }
                        if (!holder.isNegativeMAvaliehEnable && !(needToUse <= exist)) {
                            model = new LinkedHashMap<String, Object>();
                            model.put("ErpCode", dtl.getProducterpcode());
                            model.put("Few", getExist);
                            myProduct.add(model);
                            throw new TncException(TncExceptionMessages.BELOW_PRODUCTS_HAVE_NO_STORE);
                        }
                        tPriceBs += needToUse * mPriceBs;
                        if (holder.isBuildWithNoArtEnable) continue;
                        few2 = 0.0;
                        if (karton != 0.0) {
                            few2 = needToUse / karton;
                        }
                        sb = "insert into FAC_BILD (Fac_Code, A_Code, A_Index, A_Type, Fac_Code_C, Fac_Date, Fac_Time, Few, Few2, Price_BS, Comment, Extra_Field, Bild_Or_Tajzieh, resid_NO, Type_Hazineh, FacArtic_Comment, Tool, Arz,  Ghotr, Tedad, Metr, FormulaId, CalcFew) Values ('" + facCode + "','" + artsInFormula.getString("A_Code") + "','" + aIndex + "','M','" + (String)facCodeC + "','" + invoice.getDate() + "','" + buildTime + "','" + needToUse + "','" + few2 + "','" + mPriceBs + "','" + (String)comment + "','NULL','F','" + 0 + "','" + 0 + "','" + artsInFormula.getString("Comment") + "','" + 1 + "','" + 1 + "','" + 1 + "','" + 1 + "','" + 1 + "','" + formulaId + "','" + 0 + "')";
                        buildArtQueries.add(sb);
                        updateExistSql = "Update Article Set Exist = Exist - " + needToUse + " ,Exist_Mandeh = Exist_Mandeh - " + needToUse + " Where A_Code = '" + artsInFormula.getString("A_Code") + "'";
                        buildArtQueries.add(updateExistSql);
                    }
                    sb2 = new StringBuilder("insert into FAC_BILD (Fac_Code, A_Code, A_Index, A_Type, Fac_Code_C, Fac_Date, Fac_Time, Few, Few2, Price_BS, Price_Hazineh, Price_Hazineh1, Price_Hazineh2, Price_Hazineh3, Comment, Extra_Field, Bild_Or_Tajzieh, Sanad_Code, resid_NO, Type_Hazineh,  Tool, Arz, Ghotr, Tedad, Metr, FormulaId,CalcFew) Values (");
                    tPriceBs += (double)(p1 + p2 + p3) * needToBuild;
                    sb2.append("'").append(facCode).append("',").append("'").append(dtl.getProductid()).append("',").append("'").append(0).append("',").append("'").append("T").append("',").append("'").append((String)facCodeC).append("',").append("'").append(invoice.getDate()).append("',").append("'").append(buildTime.toString()).append("',").append("'").append(needToBuild).append("',").append("'").append(0).append("',").append("'").append(tPriceBs /= needToBuild).append("',").append("'").append((double)(p1 + p2 + p3) * needToBuild).append("',").append("'").append((double)p1 * needToBuild).append("',").append("'").append((double)p2 * needToBuild).append("',").append("'").append((double)p3 * needToBuild).append("',").append("'").append((String)comment).append("',").append("'").append("NULL").append("',").append("'").append("F").append("',").append("'").append(invoice.getSanadcode()).append("',").append("'").append(0).append("',").append("'").append(0).append("',").append("'").append(1).append("',").append("'").append(1).append("',").append("'").append(1).append("',").append("'").append(1).append("',").append("'").append(1).append("',").append("'").append(formulaId).append("',").append("'").append(0).append("'").append(")");
                    buildArtQueries.add(sb2.toString());
                    vasetFactorSql = "exec InsertVasetTolidFactor\n   @Fac_Code_Bild = '" + facCode + "', \n   @Fac_Code = '" + invoice.getId() + "',\n   @A_Code = '" + dtl.getProductid() + "',\n   @A_Index = '" + aIndex + "',\n   @Fac_Type = '" + invoiceType.getSymbol() + "',   @level = 0";
                    buildArtQueries.add(vasetFactorSql);
                    updateExistSql = "Update Article Set Exist = Exist + " + needToBuild + " ,Exist_Mandeh = Exist_Mandeh + " + needToBuild + " Where A_Code = '" + dtl.getProductid() + "'";
                    buildArtQueries.add(updateExistSql);
                }
                for (String query : buildArtQueries) {
                    jdbcTemplate.execute(query);
                }
                if (!buildArtQueries.isEmpty()) {
                    persianDate = DateUtils.convertToPersianDate((String)invoice.getDate());
                    processComment = " \u062a\u0648\u0644\u064a\u062f \u0627\u062a\u0648\u0645\u0627\u062a\u064a\u0643 \u0643\u0627\u0644\u0627\u064a " + tName + " \u0628\u0647 \u062a\u0639\u062f\u0627\u062f: " + needToBuild + " \u0627\u0632 \u0643\u0627\u0644\u0627\u0647\u0627\u064a: " + mNames.toString() + " \u0628\u0627 \u0634\u0645\u0627\u0631\u0647 \u062a\u0648\u0644\u064a\u062f :" + facCode + " \u0648 \u0634\u0645\u0627\u0631\u0647 \u0641\u0627\u06a9\u062a\u0648\u0631 : '" + invoice.getCode() + "' \u0628\u0647 \u062a\u0627\u0631\u064a\u062e : " + persianDate;
                    new BuildArtProcessDao(this.dbConnection, myLogin, msg).insertBuildProcess(invoice.getId(), invoice.getCustomerid(), processComment);
                }
            }
            this.checkExistPoshak(holder.negativeOfSath, invoice, myProduct, dtl, myLogin);
            if (invoiceType.equals((Object)InvoiceType.PROXY)) {
                proxyInvoiceService = proxyServiceSupplier.get();
                proxyInvoiceService.setSellerDataIntoDtl(dtl);
            } else {
                dtl.setSellercommission(0.0);
                dtl.setSellererpcode(null);
            }
            dtl.setProductcode("");
            dtl.setProductname("");
            dtl.setBuyprice(Double.valueOf(0.0));
            if (!myLogin.getIsMyHoloo().booleanValue()) {
                sqlStr = "Select A_Code_C,A_Name,Isnull(Buy_Price,0) Buy_Price,Isnull(levy,0) levy,  Isnull(scot,0) scot,Isnull(Include_Tax,0) Include_Tax From Article  Where A_Code='" + dtl.getProductid() + "'";
                rs = jdbcTemplate.queryForRowSet(sqlStr);
                while (rs.next()) {
                    if (!ConvertStr.isNullOrEmpty((String)rs.getString("A_Code_C"))) {
                        dtl.setProductcode(ConvertStr.getNullIfEmpty((String)rs.getString("A_Code_C")));
                    }
                    if (!ConvertStr.isNullOrEmpty((String)rs.getString("A_Name"))) {
                        dtl.setProductname(ConvertStr.getNullIfEmpty((String)rs.getString("A_Name")));
                    }
                    dtl.setBuyprice(Double.valueOf(rs.getDouble("Buy_Price")));
                }
            }
            dtl.setAindex(Integer.valueOf(j + 1));
            if (this.isOrder(FRegisterType)) {
                sqlStr = "select ISnull(karton,0)karton, ISnull(basteh,0)basteh From Article Where A_Code='" + dtl.getProductid() + "'";
                rs = jdbcTemplate.queryForRowSet(sqlStr);
                amountInBox = 0.0;
                amountInBasteh = 0.0;
                if (rs.next()) {
                    amountInBox = rs.getDouble("karton");
                    amountInBasteh = rs.getDouble("basteh");
                }
                rFew3 = dtl.getBasteh() == null ? 0.0 : dtl.getBasteh();
                sqlStr = "Insert into RQDETAIL(RqIndex,RqType,R_ArCode,R_ArCode_C,R_ArName,R_Few,R_FewAval,R_Few2,R_FewAval2,R_Few3,R_FewAval3,FewKarton,FewBasteh, R_Cost,unit_code,R_Commen, DarsadTakhfif, TakhfifSatriR) Values('" + invoice.getId() + "','" + invoiceType.getSymbol() + "','" + dtl.getProductid() + "','" + dtl.getProductcode() + "','" + dtl.getProductname() + "'," + dtl.getFew() + "," + dtl.getFew() + "," + dtl.getKarton() + "," + dtl.getKarton() + "," + rFew3 + "," + rFew3 + "," + amountInBox + "," + amountInBasteh + "," + dtl.getPrice() + "," + dtl.getUnitid() + ",'" + dtl.getComment() + "'," + dtl.getDiscountpercent() + "," + dtl.getDiscountprice() + ")";
                jdbcTemplate.execute(sqlStr);
            } else if (this.isPreInvoice(FRegisterType)) {
                sqlStr = "select ISnull(karton,0)karton, ISnull(basteh,0)basteh From Article Where A_Code='" + dtl.getProductid() + "'";
                rs = jdbcTemplate.queryForRowSet(sqlStr);
                amountInBox = 0.0;
                while (rs.next()) {
                    amountInBox = rs.getDouble("karton");
                }
                dtl.setFew(Double.valueOf(dtl.getFew() * Unit_Few));
                sqlStr = "Insert into AbailPre(Fac_Code, Fac_Type, A_Code, A_Index, First_Article, Few_Article, Price_Bs, Buy_Price, ACode_C, vahedcode, unit_few, FacArtic_Comment, Karton, first_article2, few_article2,basteh, Levy, Scot, TakhfifSatriR, DarsadTakhfif) Values('" + invoice.getId() + "','P','" + dtl.getProductid() + "'," + dtl.getAindex() + "," + dtl.getFew() + "," + dtl.getFew() + "," + dtl.getPrice() + "," + dtl.getBuyprice() + ",'" + dtl.getProductcode() + "','" + dtl.getUnitid() + "'," + Unit_Few + ",'" + dtl.getComment() + "'," + amountInBox + "," + dtl.getKarton() + "," + dtl.getKarton() + "," + dtl.getBasteh() + "," + dtl.getLevy() + "," + dtl.getScot() + "," + dtl.getDiscountprice() + "," + dtl.getDiscountpercent() + ")";
                jdbcTemplate.execute(sqlStr);
            } else if (this.isInvoice(FRegisterType)) {
                if (!myLogin.getIsMyHoloo().booleanValue()) {
                    sqlStr = "select ISnull(karton,0)karton,ISnull(basteh,0)basteh From Article Where A_Code='" + dtl.getProductid() + "'";
                    rs = jdbcTemplate.queryForRowSet(sqlStr);
                    amountInBox = 0.0;
                    amountInBasteh = 0.0;
                    while (rs.next()) {
                        amountInBox = rs.getDouble("karton");
                        amountInBasteh = rs.getDouble("basteh");
                    }
                    dtl.setFew(Double.valueOf(dtl.getFew() * Unit_Few));
                    if (invoiceType.equals((Object)InvoiceType.BUY)) {
                        A_BuyPriceForMiyangin = dtl.getPrice();
                        if (holder.mCalcSoodInForoosh) {
                            A_BuyPriceForMiyangin -= invoice.getDiscount();
                        }
                        UpdateSql = existProduct >= 0.0 && existProduct + dtl.getFew() > 0.0 ? " Buy_Price =" + (existProduct * dtl.getBuyprice() + dtl.getFew() * A_BuyPriceForMiyangin) / (existProduct + dtl.getFew()) : " Buy_Price =" + dtl.getFew() * A_BuyPriceForMiyangin / dtl.getFew();
                        sqlStr = " Select Top 1 Fac_Date, Fac_Time, Price_Bs From FactArt FA  Inner Join Facture F On F.Fac_Code = FA.Fac_Code And F.Fac_Type = FA.Fac_Type  And F.Fac_type = '" + invoiceType.getSymbol() + "' And A_Code = '" + dtl.getProductid() + "' Order by F.Fac_Date desc, F.Fac_Time desc ";
                        NowDate = new Date();
                        rs = jdbcTemplate.queryForRowSet(sqlStr);
                        EndBuyPrice = 0.0;
                        if (!rs.next()) {
                            EndBuyPrice = A_BuyPriceForMiyangin;
                        }
                        rs = jdbcTemplate.queryForRowSet(sqlStr);
                        while (rs.next()) {
                            if (!NowDate.after(rs.getDate("Fac_date")) && !NowDate.equals(rs.getDate("Fac_date"))) continue;
                            EndBuyPrice = A_BuyPriceForMiyangin;
                        }
                        if (EndBuyPrice > 0.0) {
                            UpdateSql = holder.mCalcSoodInForoosh != false && holder.calcSoodInForooshEndBuyPrice == false ? UpdateSql + " ,EndBuy_Price = " + (EndBuyPrice + invoice.getDiscount()) : UpdateSql + " ,EndBuy_Price = " + EndBuyPrice;
                        }
                        sqlStr = "Update Article Set " + UpdateSql + " Where A_Code = '" + dtl.getProductid() + "'";
                        jdbcTemplate.execute(sqlStr);
                    }
                    clc = invoiceType.getOperator();
                    sqlStr = "Update Article Set Exist = Exist " + clc + dtl.getFew() + " ,Exist_Mandeh = Exist_Mandeh " + clc + dtl.getFew() + " ,Exist2 = Exist2 " + clc + dtl.getKarton() + " Where A_Code = '" + dtl.getProductid() + "'";
                    jdbcTemplate.execute(sqlStr);
                    levy = dtl.getLevy();
                    scot = dtl.getScot();
                    if (invoiceType.equals((Object)InvoiceType.PROXY) && dtl.getSellerKindVAT() == 0) {
                        levy = 0.0;
                        scot = 0.0;
                    }
                    sqlStr = "Insert into Factart(Fac_Code, Fac_Type, A_Code, A_Index, Few_Article, \n Price_Bs, Buy_Price, ACode_C, vahedcode, VahedFew, FacArtic_Comment, \n FewKarton, few_article2,FewBasteh,FewinBasteh, Levy, Scot, ArtExist, TakhfifSatriR, \n DarsadTakhfif, Darsad_type \n" + (InvoiceType.PROXY.equals((Object)invoiceType) != false ? ", Seller_C_Code,  Seller_Commission_Percent, Seller_Kind_Vat)" : ")") + " Values('" + invoice.getId() + "','" + invoiceType.getSymbol() + "','" + dtl.getProductid() + "'," + dtl.getAindex() + "," + dtl.getFew() + "," + dtl.getPrice() + "," + dtl.getBuyprice() + ",'" + dtl.getProductcode() + "','" + dtl.getUnitid() + "'," + Unit_Few + ",'" + dtl.getSerialComment() + "'," + amountInBox + "," + dtl.getKarton() + "," + dtl.getBasteh() + "," + amountInBasteh + "," + levy + "," + scot + "," + existProduct + "," + dtl.getDiscountprice() + "," + dtl.getDiscountpercent() + "," + dtl.getPercentType() + (InvoiceType.PROXY.equals((Object)invoiceType) != false ? "," + ConvertStr.toQuotedSqlStr((String)dtl.getSellererpcode()) + ", " + dtl.getSellercommission() + ", " + dtl.getSellerKindVAT() + ")" : ")");
                } else {
                    sqlStr = "Insert into TmpFactart(IDFacture, A_Code, A_few, A_Few2, A_Price, Unit_code, A_Comment,Levy,Scot, DarsadTakhfif, TakhfifSatriR, A_INDEX) Values(" + ConvertStr.toQuotedSqlStr((String)invoice.getId()) + ",'" + dtl.getProductid() + "'," + dtl.getFew() + "," + dtl.getKarton() + "," + dtl.getPrice() + ",0,'" + dtl.getComment() + "'," + dtl.getLevy() + "," + dtl.getScot() + "," + dtl.getDiscountpercent() + "," + dtl.getDiscountprice() + "," + dtl.getAindex() + ")";
                }
                affectedRow = jdbcTemplate.update(sqlStr);
                if (affectedRow == 0) {
                    this.log.info(myLogin.getDatabaseName() + "$$$ TmpFactart error: id = " + invoice.getId() + " - affectedRows = " + affectedRow);
                    throw new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
                }
            }
            if (!myLogin.getIsMyHoloo().booleanValue()) {
                this.addPoshak(myLogin, FRegisterType, invoice, j + 1, dtl);
            } else {
                this.addPoshakMyHoloo(myLogin, FRegisterType, invoice, j + 1, dtl);
            }
            ++j;
            ** while (true)
        }
        for (j = 0; j < invoice.getDetailinfo().size(); ++j) {
            dtl = (InvoiceDetailDto)invoice.getDetailinfo().get(j);
            sqlStr = "SELECT Moddat FROM ARTICLE A  WHERE A_CODE = '" + dtl.getProductid() + "'";
            rs = jdbcTemplate.queryForRowSet(sqlStr);
            if (!rs.next()) continue;
            articleCalcData = new ArticleCalcData(dtl.getFew() == null ? 0.0 : dtl.getFew(), Double.valueOf(rs.getDouble("Moddat")), dtl.getPrice().doubleValue());
            articleCalcDataList.add(articleCalcData);
        }
        tasviehDate = InvoiceUtils.getVertexDate((Date)DateUtils.parseDate((String)invoice.getDate(), (String)DateUtils.defaultDateFormat.toPattern()), articleCalcDataList);
        convertedDate = DateUtils.defaultDateTimeFormat.format(tasviehDate);
        sqlStr = "UPDATE Facture SET TasviehDate='" + convertedDate + "' WHERE Fac_Code = '" + invoice.getId() + "'";
        jdbcTemplate.execute(sqlStr);
        ** while (true)
    }

    private void validationForEditAndDeleteFacture(JdbcTemplate jdbcTemplate, InvoiceDto.InvoiceInfo invoice, InvoiceType invoiceType, int FregisterType) {
        SqlRowSet rs = jdbcTemplate.queryForRowSet("select count(*) cnt from ItemFact fac \nwhere fac.Fac_Code = ? and fac.fac_type = ?", new Object[]{ConvertStr.decrypt((String)invoice.getErpcode()), invoiceType.getSymbol()});
        if (rs.next() && rs.getInt("cnt") > 0) {
            throw new TncException(TncExceptionMessages.NOT_VALID_FOR_UPDATE);
        }
        rs = jdbcTemplate.queryForRowSet("select * from fac_ser where Fac_code = ? and fac_type = ? ", new Object[]{ConvertStr.decrypt((String)invoice.getErpcode()), invoiceType.getSymbol()});
        if (rs.next()) {
            throw new TncException(TncExceptionMessages.NOT_VALID_FOR_UPDATE);
        }
        String putValidationSql = "";
        if (this.isInvoice(FregisterType)) {
            putValidationSql = "select * from facture where fac_code = ? and fac_type = ?";
        } else if (this.isOrder(FregisterType)) {
            putValidationSql = "select * from RQTITLE where rqindex = ? and rqtype = ? ";
        } else {
            throw new TncException(TncExceptionMessages.FORBIDDEN_TO_UPDATE);
        }
        rs = jdbcTemplate.queryForRowSet(putValidationSql, new Object[]{ConvertStr.decrypt((String)invoice.getErpcode()), invoiceType.getSymbol()});
        if (rs.next()) {
            if (this.isOrder(FregisterType)) {
                boolean showOrHide = rs.getBoolean("ShowOrHide");
                if (!showOrHide) {
                    throw new TncException(TncExceptionMessages.FORBIDDEN_TO_UPDATE);
                }
                invoice.setId(rs.getString("rqindex"));
                invoice.setCode(rs.getInt("rqindex2"));
                invoice.setSanadcode(rs.getInt("Sanad_Code"));
            } else if (this.isInvoice(FregisterType)) {
                String webId = rs.getString("WebId");
                double sumCheck = rs.getDouble("FCheck");
                String taxId = rs.getString("FTaxId");
                String taxIdLog = rs.getString("FTaxIdLog");
                if (webId == null || sumCheck > 0.0 || taxId != null || taxIdLog != null || !invoice.getInvoiceType().getSymbol().equalsIgnoreCase("F")) {
                    throw new TncException(TncExceptionMessages.NOT_VALID_FOR_UPDATE);
                }
                invoice.setId(rs.getString("fac_code"));
                if (invoice.getCode() == 0) {
                    invoice.setCode(rs.getInt("fac_code_c"));
                }
                invoice.setSanadcode(rs.getInt("Sanad_Code"));
            }
        } else {
            throw new TncException(TncExceptionMessages.NOT_FOUND_FACTURE);
        }
    }

    private void ChangeSanadDate(TncJdbc jdbcTemplate, int sanadCode, String sanadDate) {
        String sanad_date = "";
        sanadDate = sanadDate.replace("-", "/");
        SqlRowSet rs = jdbcTemplate.queryForRowSet("select Convert(nvarchar(10),sanad_date,111) sanad_date from sanad where sanad_code = " + sanadCode);
        if (rs.next()) {
            sanad_date = rs.getString("sanad_date");
        }
        if (!sanad_date.isEmpty() && !sanad_date.equals(sanadDate)) {
            this.ReturnMinMax_CodeSanad_For_OneDay((JdbcTemplate)jdbcTemplate, sanadDate);
            int Code_C = this.Max_CodeSanad;
            int Code_C2 = this.returnSanadCode2((JdbcTemplate)jdbcTemplate, Code_C, sanadDate);
            int Comparison = sanad_date.compareTo(sanadDate);
            if (Comparison < 0 && (rs = jdbcTemplate.queryForRowSet("Select Count(*) cnt From Sanad Where Sanad_Date >= ? ", new Object[]{sanadDate})).next() && rs.getInt("cnt") == 0) {
                rs = jdbcTemplate.queryForRowSet("Select Count(*) cnt From Sanad Where Sanad_Date Between ? and ?", new Object[]{sanad_date, sanadDate});
                if (rs.next() && rs.getInt("cnt") > 0 && (rs = jdbcTemplate.queryForRowSet("Select Max(Sanad_Code_C)+1 Sanad_Code_C From Sanad Where Sanad_code <> ?", new Object[]{sanadCode})).next()) {
                    Code_C = rs.getInt("Sanad_Code_C");
                }
                Code_C2 = 0;
            }
            jdbcTemplate.update("update sanad  SET Sanad_Code_C = ? ,Sanad_Code_C2 = ?,Sanad_Date = ? WHERE Sanad_Code = ? ", new Object[]{Code_C, Code_C2, sanadDate, sanadCode});
        }
    }

    private Integer saveSanad(InvoiceDto.InvoiceInfo invoice, InvoiceType invoiceType, int FregisterType, LoginDto myLogin, String tableName, String facType, String facCode, double sumPrice, double sumLevy, double sumScot, InvoiceSetupValueHolder holder, double sumOfAllIncomes, double sumOfAllCosts, String avarezShahrdary, String avarezAmozesh, Request request, Integer facCodeC) {
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
        SettingLoader settingLoader = new SettingLoader(this.dbConnection, myLogin);
        int Sanad_Type = 14;
        if (invoiceType.isOfSaleNature()) {
            Sanad_Type = 13;
        }
        if (this.isOrder(FregisterType)) {
            Sanad_Type = 5;
            if (invoiceType.isOfSaleNature()) {
                Sanad_Type = 4;
            }
        }
        int Action = 0;
        if (invoice.getCash() > 0.0) {
            Action = 1;
        }
        String sqlStr = "";
        int Code_C = 0;
        int Code_C2 = 0;
        int sanadCode = invoice.getSanadcode();
        if (request.equals((Object)Request.POST)) {
            this.ReturnMinMax_CodeSanad_For_OneDay((JdbcTemplate)jdbcTemplate, invoice.getDate());
            Code_C = this.Max_CodeSanad;
            Code_C2 = this.returnSanadCode2((JdbcTemplate)jdbcTemplate, Code_C, invoice.getDate());
            this.incSanadCode((JdbcTemplate)jdbcTemplate, Code_C, Code_C2);
            int SaveFromFacture = 1;
            if (this.isOrder(FregisterType)) {
                SaveFromFacture = 0;
            }
            sqlStr = " INSERT INTO SANAD(Sanad_Code_C, Sanad_Code_C2, Comment, Sanad_Date, Sanad_Time, End_Save, SaveFromFacture, SaveFromAuto, User1, NaghdCheck, DateUser, TimeUser, UserCodeInc, Actions, Number_U, Sanad_Type,EndeditDate)  VALUES(" + Code_C + "," + Code_C2 + ",'','" + invoice.getDate() + "','" + invoice.getTime() + "', 0," + SaveFromFacture + ",0,0,0,convert(Nvarchar(10),getdate(),111),convert(Nvarchar(5),getdate(),108),'" + myLogin.getUserCodeInc() + "','" + Action + "',0,'" + Sanad_Type + "',getdate())";
            int affectedRow = jdbcTemplate.update(sqlStr);
            sanadCode = (int)GetIdentity.invoke((TncJdbc)jdbcTemplate);
            if (sanadCode <= 0 || affectedRow == 0) {
                throw new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
            }
        } else {
            this.ChangeSanadDate(jdbcTemplate, sanadCode, invoice.getDate());
            jdbcTemplate.update("UPDATE sanad SET     DateUser = CONVERT(NVARCHAR(10), GETDATE(), 111),   TimeUser = CONVERT(NVARCHAR(5), GETDATE(), 108), UserCodeInc = ?, Actions = ?,  Sanad_Type = ?,  EndeditDate = GETDATE() WHERE sanad_code = ?", new Object[]{myLogin.getUserCodeInc(), Action, Sanad_Type, sanadCode});
        }
        if (this.isInvoice(FregisterType) && sanadCode <= 0) {
            throw new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
        }
        if (InvoiceType.PROXY.equals((Object)invoiceType)) {
            String sanadComment = "\u0628\u0627\u0628\u062a \u0641\u0631\u0648\u0634 \u06a9\u0627\u0644\u0627\u060c \u0637\u06cc \u0641\u0627\u06a9\u062a\u0648\u0631 \u062d\u0642\u200c\u0627\u0644\u0639\u0645\u0644\u200c\u06a9\u0627\u0631\u06cc \u0634\u0645\u0627\u0631\u0647 " + facCodeC;
            jdbcTemplate.update(" UPDATE SANAD SET [COMMENT] = ?  WHERE SANAD_CODE = ?", new Object[]{sanadComment, sanadCode});
        }
        invoice.setSanadcode(sanadCode);
        if (invoice.getCheckinfo() == null || invoice.getCheckinfo().isEmpty()) {
            sqlStr = " INSERT INTO SND_indx(Sanad_Code, Fac_Code, Fac_Type, Check_Code)  VALUES(" + sanadCode + ",'" + invoice.getId() + "','" + invoiceType.getSymbol() + "',0)";
            jdbcTemplate.execute(sqlStr);
        }
        String customerSarfasl = "";
        SqlRowSet rs = jdbcTemplate.queryForRowSet("Select c_code,   Case    when Isnull(Col_code_bed,'') <> '' And Isnull(Col_code_bes,'')='' then        Isnull(Col_code_bed,'')+Isnull(Moien_code_bed,'')+Isnull(Tafzili_Code_Bed,'')    when Isnull(Col_code_bed,'') = '' And Isnull(Col_code_bes,'')<>'' then       Isnull(Col_code_bes,'')+Isnull(Moien_code_bes,'')+Isnull(Tafzili_Code_Bes,'')     when '" + invoiceType.getSymbol() + "' in ('K','X') then        Isnull(Col_code_bes,'')+Isnull(Moien_code_bes,'')+Isnull(Tafzili_Code_Bes,'')    when '" + invoiceType.getSymbol() + "' in ('F','Y') then       Isnull(Col_code_bed,'')+Isnull(Moien_code_bed,'')+Isnull(Tafzili_Code_Bed,'')       end CustomerSarfasl  from customer where C_Code='" + invoice.getCustomerid() + "'");
        while (rs.next()) {
            customerSarfasl = rs.getString("CustomerSarfasl");
        }
        jdbcTemplate.execute(" Update " + tableName + " Set Sanad_Code=" + sanadCode + " Where " + facType + " ='" + invoiceType.getSymbol() + "' And " + facCode + " ='" + invoice.getId() + "'");
        this.expenseDao.updateSanadCode(sanadCode, invoice.getId() + invoiceType.getSymbol(), myLogin);
        String invoiceTypeName = invoiceType.getFarsiName();
        String lastCostSarfaslCode = "";
        if (this.isCostAvailable(invoice)) {
            List additionalCosts = invoice.getHazineinfo();
            lastCostSarfaslCode = ((InvoiceExpenseDto)additionalCosts.get(additionalCosts.size() - 1)).getSarfaslcode();
        }
        if (this.isIncomeAvailable(invoice)) {
            List additionalIncomes = invoice.getIncomeinfo();
            lastCostSarfaslCode = ((InvoiceExpenseDto)additionalIncomes.get(additionalIncomes.size() - 1)).getSarfaslcode();
            sumOfAllCosts += sumOfAllIncomes;
        }
        if (this.isInvoice(FregisterType)) {
            jdbcTemplate.execute(" UPDATE FACTURE SET HAZFACTK =" + sumOfAllCosts + ", HAZSARFASL ='" + lastCostSarfaslCode + "' Where Fac_Type='" + invoiceType.getSymbol() + "' And Fac_Code='" + invoice.getId() + "'");
        }
        IndustrialInvoiceService industrialService = new IndustrialInvoiceService(DbLogin.getInstance((DbConnection)this.dbConnection, (LoginDto)myLogin));
        industrialService.generate_article_sarfasl_of_invoice_articles(invoice.getDetailinfo());
        CommissionCalculator commissionCalculator = new CommissionCalculator(DbLogin.getNewInstance((DbConnection)this.dbConnection, (LoginDto)myLogin), invoice);
        commissionCalculator.calculateCommission();
        commissionCalculator.insertFConnect();
        double bank = invoice.getBank();
        switch (1.$SwitchMap$com$dao$InvoiceDao$InvoiceType[invoiceType.ordinal()]) {
            case 1: {
                if (!industrialService.isIndustrial()) {
                    if (this.isInvoice(FregisterType)) {
                        this.sanadAdd(PaymentDetailDto.builder().colcode("801").moiencode("0001").bed(Double.valueOf(sumPrice)).commentline(" \u0634\u0645\u0627\u0631\u0647 " + invoice.getCode() + " " + invoice.getCustomername()));
                    }
                } else {
                    for (ArticleSarfasl articleSarfasl : industrialService.getInvoiceArticlesSarfaslList()) {
                        this.sanadAdd(PaymentDetailDto.builder().colcode(articleSarfasl.getMainCol()).moiencode(articleSarfasl.getMainMoein()).tafzilicode(articleSarfasl.getMainTafsili()).bed(articleSarfasl.getArticleTotalPrice()).commentline(invoiceTypeName + " \u0634\u0645\u0627\u0631\u0647" + invoice.getCode()).numberline(articleSarfasl.getNumberLine()));
                    }
                }
                if (sumScot > 0.0) {
                    this.sanadAdd(PaymentDetailDto.builder().colcode(avarezShahrdary.substring(0, 3)).moiencode(avarezShahrdary.substring(3, 7)).tafzilicode(avarezShahrdary.substring(7)).bed(Double.valueOf(sumScot)).commentline(invoiceTypeName + " \u0634\u0645\u0627\u0631\u0647" + invoice.getCode()));
                }
                if (sumLevy > 0.0) {
                    this.sanadAdd(PaymentDetailDto.builder().colcode(avarezAmozesh.substring(0, 3)).moiencode(avarezAmozesh.substring(3, 7)).tafzilicode(avarezAmozesh.substring(7)).bed(Double.valueOf(sumLevy)).commentline(invoiceTypeName + " \u0634\u0645\u0627\u0631\u0647" + invoice.getCode()));
                }
                if (this.isInvoice(FregisterType)) {
                    this.sanadAdd(PaymentDetailDto.builder().colcode(customerSarfasl.substring(0, 3)).moiencode(customerSarfasl.substring(3, 7)).tafzilicode(customerSarfasl.substring(7)).bes(Double.valueOf(sumPrice + sumLevy + sumScot)).typeline("F").commentline("\u0641\u0627\u0643\u062a\u0648\u0631 " + invoiceTypeName + " " + invoice.getCode()));
                }
                for (PaymentDetailDto.Builder paymentDto : this.expenseCalculator.getSanadDetails(invoice, invoiceTypeName)) {
                    this.sanadAdd(paymentDto);
                }
                for (PaymentDetailDto.Builder paymentDto : this.incomeCalculator.getSanadDetails(invoice, invoiceTypeName)) {
                    this.sanadAdd(paymentDto);
                }
                String Comment = this.makePaidSanadComment(invoice, invoiceTypeName, bank);
                if (invoice.getCash() + bank + invoice.getDiscount() + invoice.getSumcheck() > 0.0) {
                    this.sanadAdd(PaymentDetailDto.builder().colcode(customerSarfasl.substring(0, 3)).moiencode(customerSarfasl.substring(3, 7)).tafzilicode(customerSarfasl.substring(7)).bed(Double.valueOf(invoice.getCash() + bank + invoice.getDiscount() + invoice.getSumcheck())).typeline("S").commentline(Comment + " " + invoice.getCode()));
                }
                if (invoice.getCheckinfo() != null) {
                    this.addSanadCheck((PaymentDto)invoice.getCheckinfo().get(0), invoice);
                }
                String comment = invoiceTypeName + " " + invoice.getCode() + '-' + invoice.getCustomername();
                if (this.isOrder(FregisterType)) {
                    comment = " \u067e\u0631\u062f\u0627\u062e\u062a \u0628\u0647 " + invoice.getCustomername() + " \u0628\u0627\u0628\u062a \u0633\u0641\u0627\u0631\u0634 \u062e\u0631\u06cc\u062f " + invoice.getCode();
                }
                if (invoice.getCash() > 0.0) {
                    this.sanadAdd(PaymentDetailDto.builder().colcode(invoice.getCashsarfasl().substring(0, 3)).moiencode(invoice.getCashsarfasl().substring(3, 7)).tafzilicode(invoice.getCashsarfasl().substring(7)).bes(Double.valueOf(invoice.getCash())).typeline("Z").commentline(comment));
                }
                if (invoice.getBank() > 0.0) {
                    this.sanadAdd(PaymentDetailDto.builder().colcode(invoice.getBanksarfasl().substring(0, 3)).moiencode(invoice.getBanksarfasl().substring(3, 7)).tafzilicode(invoice.fetchBankTafsili()).bes(Double.valueOf(invoice.getBank())).typeline("Z").commentline(comment));
                }
                if (invoice.getPosinfos() != null) {
                    for (Object posInfo : invoice.getPosinfos()) {
                        this.sanadAdd(PaymentDetailDto.builder().colcode(posInfo.getBanksarfasl().substring(0, 3)).moiencode(posInfo.getBanksarfasl().substring(3, 7)).tafzilicode(posInfo.fetchBankTafsili()).bes(Double.valueOf(posInfo.getBank())).typeline("Z").commentline(invoiceTypeName + " " + invoice.getCode() + '-' + invoice.getCustomername()));
                    }
                }
                if (invoice.getDiscount() > 0.0) {
                    this.sanadAdd(PaymentDetailDto.builder().colcode("803").moiencode("0001").bes(Double.valueOf(invoice.getDiscount())).typeline("Z").commentline("\u0628\u0627\u0628\u062a \u0641\u0627\u0643\u062a\u0648\u0631 " + invoice.getCode() + " " + invoice.getCustomername()));
                }
                if (!settingLoader.SaveCustForVaseteh() || invoice.getVaseteh() == null) break;
                this.insertToSndListSaveForCustPorsant(invoice, (JdbcTemplate)jdbcTemplate, invoiceTypeName);
                break;
            }
            case 2: 
            case 3: {
                String payCommentLine;
                Object sb3;
                if (this.isInvoice(FregisterType)) {
                    this.sanadAdd(PaymentDetailDto.builder().colcode(customerSarfasl.substring(0, 3)).moiencode(customerSarfasl.substring(3, 7)).tafzilicode(customerSarfasl.substring(7)).bed(Double.valueOf(sumPrice + sumLevy + sumScot)).typeline("F").commentline("\u0641\u0627\u0643\u062a\u0648\u0631 " + invoiceTypeName + " " + invoice.getCode()));
                }
                HashMap<String, ProxySellerData> sellersDebtMap = new HashMap<String, ProxySellerData>();
                if (invoiceType.equals((Object)InvoiceType.PROXY)) {
                    KindVAT kindVatCalcTool = KindVAT.find((int)holder.kindVAT);
                    for (int i = 0; i < invoice.getDetailinfo().size(); ++i) {
                        InvoiceDetailDto dtl = (InvoiceDetailDto)invoice.getDetailinfo().get(i);
                        ProxySellerData existingDebt = sellersDebtMap.getOrDefault(dtl.getSellersarfasl(), ProxySellerData.builder().build());
                        double price = dtl.getPrice() * dtl.getFew();
                        Pair levyScotPair = kindVatCalcTool.calculateLevyScot(invoice, price, Integer.valueOf(i));
                        double tax = (Double)levyScotPair.getRight() + (Double)levyScotPair.getLeft();
                        double newPrice = price + tax;
                        existingDebt.addToSumDebt((double)Math.round(newPrice));
                        existingDebt.addToSumCommission((double)Math.round(price * dtl.getSellercommission() / 100.0));
                        existingDebt.setSellerName(dtl.getSellerName());
                        existingDebt.setSellerKindVAT(dtl.getSellerKindVAT());
                        sellersDebtMap.put(dtl.getSellersarfasl(), existingDebt);
                    }
                    sellersDebtMap.forEach((sellerHeading, proxySellerData) -> this.sanadAdd(PaymentDetailDto.builder().colcode(sellerHeading.substring(0, 3)).moiencode(sellerHeading.substring(3, 7)).tafzilicode(sellerHeading.substring(7)).bes(Double.valueOf(proxySellerData.getSumDebt())).commentline(" \u0634\u0645\u0627\u0631\u0647 " + invoice.getCode() + " " + proxySellerData.getSellerName())));
                } else {
                    if (!industrialService.isIndustrial()) {
                        String colCode = this.settingDao.getMSetup2Boolean(myLogin, "ConvertNewSarfasl") ? "601" : "901";
                        if (this.isInvoice(FregisterType)) {
                            this.sanadAdd(PaymentDetailDto.builder().colcode(colCode).moiencode("0001").bes(Double.valueOf(sumPrice)).commentline(" \u0634\u0645\u0627\u0631\u0647 " + invoice.getCode() + " " + invoice.getCustomername()));
                        }
                    } else {
                        sb3 = new StringBuilder();
                        for (ArticleSarfasl aSarfasl : industrialService.getInvoiceArticlesSarfaslList()) {
                            ((StringBuilder)sb3).delete(0, ((StringBuilder)sb3).length());
                            this.sanadAdd(PaymentDetailDto.builder().colcode(aSarfasl.getOffPriceCol()).moiencode(aSarfasl.getOffPriceMoein()).tafzilicode(aSarfasl.getOffPriceTafsili()).bed(aSarfasl.getArticleTotalBuyPrice()).commentline(((StringBuilder)sb3).append("\u0642\u06cc\u0645\u062a \u062a\u0645\u0627\u0645 \u0634\u062f\u0647_").append(invoiceTypeName).append(" \u0634\u0645\u0627\u0631\u0647").append(invoice.getCode()).toString()));
                        }
                    }
                    if (sumScot > 0.0) {
                        this.sanadAdd(PaymentDetailDto.builder().colcode(avarezShahrdary.substring(0, 3)).moiencode(avarezShahrdary.substring(3, 7)).tafzilicode(avarezShahrdary.substring(7)).bes(Double.valueOf(sumScot)).commentline(invoiceTypeName + " \u0634\u0645\u0627\u0631\u0647" + invoice.getCode()));
                    }
                    if (sumLevy > 0.0) {
                        this.sanadAdd(PaymentDetailDto.builder().colcode(avarezAmozesh.substring(0, 3)).moiencode(avarezAmozesh.substring(3, 7)).tafzilicode(avarezAmozesh.substring(7)).bes(Double.valueOf(sumLevy)).commentline(invoiceTypeName + " \u0634\u0645\u0627\u0631\u0647" + invoice.getCode()));
                    }
                }
                for (PaymentDetailDto.Builder paymentDto : this.expenseCalculator.getSanadDetails(invoice, invoiceTypeName)) {
                    this.sanadAdd(paymentDto);
                }
                for (PaymentDetailDto.Builder paymentDto : this.incomeCalculator.getSanadDetails(invoice, invoiceTypeName)) {
                    this.sanadAdd(paymentDto);
                }
                String string = this.isInvoice(FregisterType) ? (invoiceType.equals((Object)InvoiceType.SALE) ? "\u0628\u0627\u0628\u062a " : "") + invoiceTypeName + " " + invoice.getCode() + "-" + invoice.getCustomername() : (payCommentLine = (invoiceType.equals((Object)InvoiceType.PROXY) ? "\u0628\u0627\u0628\u062a " : "\u062f\u0631\u06cc\u0627\u0641\u062a \u0627\u0632  -  \u0628\u0627\u0628\u062a \u0633\u0641\u0627\u0631\u0634 ") + invoiceTypeName + " " + invoice.getCode() + "-" + invoice.getCustomername());
                if (invoice.getCheckinfo() != null) {
                    this.addSanadCheck((PaymentDto)invoice.getCheckinfo().get(0), invoice);
                }
                if (invoice.getCash() > 0.0) {
                    this.sanadAdd(PaymentDetailDto.builder().colcode(invoice.getCashsarfasl().substring(0, 3)).moiencode(invoice.getCashsarfasl().substring(3, 7)).tafzilicode(invoice.getCashsarfasl().substring(7)).bed(Double.valueOf(invoice.getCash())).typeline("Z").commentline(payCommentLine));
                }
                if (invoice.getBank() > 0.0) {
                    this.sanadAdd(PaymentDetailDto.builder().colcode(invoice.getBanksarfasl().substring(0, 3)).moiencode(invoice.getBanksarfasl().substring(3, 7)).tafzilicode(invoice.fetchBankTafsili()).bed(Double.valueOf(invoice.getBank())).typeline("Z").commentline(payCommentLine));
                }
                if (invoice.getPosinfos() != null) {
                    for (Object posInfo : invoice.getPosinfos()) {
                        this.sanadAdd(PaymentDetailDto.builder().colcode(posInfo.getBanksarfasl().substring(0, 3)).moiencode(posInfo.getBanksarfasl().substring(3, 7)).tafzilicode(posInfo.fetchBankTafsili()).bed(Double.valueOf(posInfo.getBank())).typeline("Z").commentline(payCommentLine));
                    }
                }
                if (invoice.getDiscount() > 0.0) {
                    String colCode = this.settingDao.getMSetup2Boolean(myLogin, "ConvertNewSarfasl") ? "603" : "903";
                    this.sanadAdd(PaymentDetailDto.builder().colcode(colCode).moiencode("0001").bed(Double.valueOf(invoice.getDiscount())).typeline("Z").commentline("\u0628\u0627\u0628\u062a \u0641\u0627\u0643\u062a\u0648\u0631 " + invoice.getCode() + " " + invoice.getCustomername()));
                }
                if (industrialService.isIndustrial()) {
                    StringBuilder sb2 = new StringBuilder();
                    for (ArticleSarfasl aSarfasl : industrialService.getInvoiceArticlesSarfaslList()) {
                        sb2.delete(0, sb2.length());
                        this.sanadAdd(PaymentDetailDto.builder().colcode(aSarfasl.getSellCol()).moiencode(aSarfasl.getSellMoein()).tafzilicode(aSarfasl.getSellTafsili()).bes(aSarfasl.getArticleTotalPrice()).commentline(sb2.append(invoiceTypeName).append(" \u0634\u0645\u0627\u0631\u0647").append(invoice.getCode()).toString()));
                    }
                    for (ArticleSarfasl aSarfasl : industrialService.getInvoiceArticlesSarfaslList()) {
                        sb2.delete(0, sb2.length());
                        this.sanadAdd(PaymentDetailDto.builder().colcode(aSarfasl.getMainCol()).moiencode(aSarfasl.getMainMoein()).tafzilicode(aSarfasl.getMainTafsili()).bes(aSarfasl.getArticleTotalBuyPrice()).commentline(sb2.append("\u0627\u0646\u0628\u0627\u0631 \u0645\u062d\u0635\u0648\u0644_").append(invoiceTypeName).append(" \u0634\u0645\u0627\u0631\u0647").append(invoice.getCode()).toString()).numberline(aSarfasl.getNumberLine()));
                    }
                }
                String Comment = this.makeReceivedSanadComment(invoice, invoiceTypeName, bank);
                if (invoice.getCash() + bank + invoice.getDiscount() + invoice.getSumcheck() > 0.0) {
                    this.sanadAdd(PaymentDetailDto.builder().colcode(customerSarfasl.substring(0, 3)).moiencode(customerSarfasl.substring(3, 7)).tafzilicode(customerSarfasl.substring(7)).bes(Double.valueOf(invoice.getCash() + bank + invoice.getDiscount() + invoice.getSumcheck())).typeline("S").commentline(Comment + " " + invoice.getCode()));
                }
                if (!settingLoader.SaveCustForVaseteh() || invoice.getVaseteh() == null) break;
                this.insertToSndListSaveForCustPorsant(invoice, (JdbcTemplate)jdbcTemplate, invoiceTypeName);
                break;
            }
            case 4: {
                StringBuilder sb;
                if (this.isInvoice(FregisterType)) {
                    this.sanadAdd(PaymentDetailDto.builder().colcode(customerSarfasl.substring(0, 3)).moiencode(customerSarfasl.substring(3, 7)).tafzilicode(customerSarfasl.substring(7)).bed(Double.valueOf(sumPrice + sumLevy + sumScot)).typeline("F").commentline("\u0641\u0627\u0643\u062a\u0648\u0631 " + invoiceTypeName + " " + invoice.getCode()));
                }
                if (!industrialService.isIndustrial()) {
                    this.sanadAdd(PaymentDetailDto.builder().colcode("802").moiencode("0001").bes(Double.valueOf(sumPrice)).commentline(" \u0634\u0645\u0627\u0631\u0647 " + invoice.getCode() + " " + invoice.getCustomername()));
                }
                if (sumScot > 0.0) {
                    this.sanadAdd(PaymentDetailDto.builder().colcode(avarezShahrdary.substring(0, 3)).moiencode(avarezShahrdary.substring(3, 7)).tafzilicode(avarezShahrdary.substring(7)).bes(Double.valueOf(sumScot)).commentline(invoiceTypeName + " \u0634\u0645\u0627\u0631\u0647" + invoice.getCode()));
                }
                if (sumLevy > 0.0) {
                    this.sanadAdd(PaymentDetailDto.builder().colcode(avarezAmozesh.substring(0, 3)).moiencode(avarezAmozesh.substring(3, 7)).tafzilicode(avarezAmozesh.substring(7)).bes(Double.valueOf(sumLevy)).commentline(invoiceTypeName + " \u0634\u0645\u0627\u0631\u0647" + invoice.getCode()));
                }
                if (invoice.getCash() > 0.0) {
                    this.sanadAdd(PaymentDetailDto.builder().colcode(invoice.getCashsarfasl().substring(0, 3)).moiencode(invoice.getCashsarfasl().substring(3, 7)).tafzilicode(invoice.getCashsarfasl().substring(7)).bed(Double.valueOf(invoice.getCash())).typeline("Z").commentline(invoiceTypeName + " " + invoice.getCode() + '-' + invoice.getCustomername()));
                }
                if (invoice.getBank() > 0.0) {
                    this.sanadAdd(PaymentDetailDto.builder().colcode(invoice.getBanksarfasl().substring(0, 3)).moiencode(invoice.getBanksarfasl().substring(3, 7)).tafzilicode(invoice.fetchBankTafsili()).bed(Double.valueOf(invoice.getBank())).typeline("Z").commentline(invoiceTypeName + " " + invoice.getCode() + '-' + invoice.getCustomername()));
                }
                if (invoice.getPosinfos() != null) {
                    for (Object posInfo : invoice.getPosinfos()) {
                        this.sanadAdd(PaymentDetailDto.builder().colcode(posInfo.getBanksarfasl().substring(0, 3)).moiencode(posInfo.getBanksarfasl().substring(3, 7)).tafzilicode(posInfo.fetchBankTafsili()).bed(Double.valueOf(posInfo.getBank())).typeline("Z").commentline(invoiceTypeName + " " + invoice.getCode() + '-' + invoice.getCustomername()));
                    }
                }
                if (invoice.getDiscount() > 0.0) {
                    this.sanadAdd(PaymentDetailDto.builder().colcode("803").moiencode("0001").bed(Double.valueOf(invoice.getDiscount())).typeline("Z").commentline("\u0628\u0627\u0628\u062a \u0641\u0627\u0643\u062a\u0648\u0631 " + invoice.getCode() + " " + invoice.getCustomername()));
                }
                if (industrialService.isIndustrial()) {
                    sb = new StringBuilder();
                    for (Object aSarfasl : industrialService.getInvoiceArticlesSarfaslList()) {
                        sb.delete(0, sb.length());
                        this.sanadAdd(PaymentDetailDto.builder().colcode(aSarfasl.getMainCol()).moiencode(aSarfasl.getMainMoein()).tafzilicode(aSarfasl.getMainTafsili()).bes(aSarfasl.getArticleTotalPrice()).commentline(sb.append(invoiceTypeName).append(" \u0634\u0645\u0627\u0631\u0647 ").append(invoice.getCode()).toString()).numberline(aSarfasl.getNumberLine()));
                    }
                }
                String Comment = this.makeReceivedSanadComment(invoice, invoiceTypeName, bank);
                if (invoice.getCash() + bank + invoice.getDiscount() + invoice.getSumcheck() > 0.0) {
                    this.sanadAdd(PaymentDetailDto.builder().colcode(customerSarfasl.substring(0, 3)).moiencode(customerSarfasl.substring(3, 7)).tafzilicode(customerSarfasl.substring(7)).bes(Double.valueOf(invoice.getCash() + bank + invoice.getDiscount())).typeline("S").commentline(Comment + " " + invoice.getCode()));
                }
                if (!settingLoader.SaveCustForVaseteh() || invoice.getVaseteh() == null) break;
                this.insertToSndListSaveForCustPorsant(invoice, (JdbcTemplate)jdbcTemplate, invoiceTypeName);
                break;
            }
            case 5: {
                StringBuilder sb;
                if (!industrialService.isIndustrial()) {
                    String colCode = this.settingDao.getMSetup2Boolean(myLogin, "ConvertNewSarfasl") ? "602" : "902";
                    this.sanadAdd(PaymentDetailDto.builder().colcode(colCode).moiencode("0001").bed(Double.valueOf(sumPrice)).commentline(" \u0634\u0645\u0627\u0631\u0647 " + invoice.getCode() + " " + invoice.getCustomername()));
                } else {
                    sb = new StringBuilder();
                    for (Object aSarfasl : industrialService.getInvoiceArticlesSarfaslList()) {
                        sb.delete(0, sb.length());
                        this.sanadAdd(PaymentDetailDto.builder().colcode(aSarfasl.getRetSellCol()).moiencode(aSarfasl.getRetSellMoein()).tafzilicode(aSarfasl.getRetSellTafsili()).bed(aSarfasl.getArticleTotalPrice()).commentline(sb.append(invoiceTypeName).append(" \u0634\u0645\u0627\u0631\u0647").append(invoice.getCode()).toString()));
                    }
                    for (Object aSarfasl : industrialService.getInvoiceArticlesSarfaslList()) {
                        sb.delete(0, sb.length());
                        this.sanadAdd(PaymentDetailDto.builder().colcode(aSarfasl.getMainCol()).moiencode(aSarfasl.getMainMoein()).tafzilicode(aSarfasl.getMainTafsili()).bed(aSarfasl.getArticleTotalBuyPrice()).commentline(sb.append("\u0627\u0646\u0628\u0627\u0631 \u0645\u062d\u0635\u0648\u0644_").append(invoiceTypeName).append(" \u0634\u0645\u0627\u0631\u0647").append(invoice.getCode()).toString()).numberline(aSarfasl.getNumberLine()));
                    }
                }
                if (sumScot > 0.0) {
                    this.sanadAdd(PaymentDetailDto.builder().colcode(avarezShahrdary.substring(0, 3)).moiencode(avarezShahrdary.substring(3, 7)).tafzilicode(avarezShahrdary.substring(7)).bed(Double.valueOf(sumScot)).commentline(invoiceTypeName + " \u0634\u0645\u0627\u0631\u0647" + invoice.getCode()));
                }
                if (sumLevy > 0.0) {
                    this.sanadAdd(PaymentDetailDto.builder().colcode(avarezAmozesh.substring(0, 3)).moiencode(avarezAmozesh.substring(3, 7)).tafzilicode(avarezAmozesh.substring(7)).bed(Double.valueOf(sumLevy)).commentline(invoiceTypeName + " \u0634\u0645\u0627\u0631\u0647" + invoice.getCode()));
                }
                String Comment = this.makePaidSanadComment(invoice, invoiceTypeName, bank);
                if (invoice.getCash() + bank + invoice.getDiscount() > 0.0) {
                    this.sanadAdd(PaymentDetailDto.builder().colcode(customerSarfasl.substring(0, 3)).moiencode(customerSarfasl.substring(3, 7)).tafzilicode(customerSarfasl.substring(7)).bed(Double.valueOf(invoice.getCash() + bank + invoice.getDiscount())).typeline("S").commentline(Comment + " " + invoice.getCode()));
                }
                Object sb3 = new StringBuilder();
                for (ArticleSarfasl aSarfasl : industrialService.getInvoiceArticlesSarfaslList()) {
                    ((StringBuilder)sb3).delete(0, ((StringBuilder)sb3).length());
                    this.sanadAdd(PaymentDetailDto.builder().colcode(aSarfasl.getOffPriceCol()).moiencode(aSarfasl.getOffPriceMoein()).tafzilicode(aSarfasl.getOffPriceTafsili()).bes(aSarfasl.getArticleTotalBuyPrice()).commentline(((StringBuilder)sb3).append("\u0642\u06cc\u0645\u062a \u062a\u0645\u0627\u0645 \u0634\u062f\u0647_").append(invoiceTypeName).append(" \u0634\u0645\u0627\u0631\u0647").append(invoice.getCode()).toString()));
                }
                this.sanadAdd(PaymentDetailDto.builder().colcode(customerSarfasl.substring(0, 3)).moiencode(customerSarfasl.substring(3, 7)).tafzilicode(customerSarfasl.substring(7)).bes(Double.valueOf(sumPrice + sumLevy + sumScot)).typeline("F").commentline("\u0641\u0627\u0643\u062a\u0648\u0631 " + invoiceTypeName + " " + invoice.getCode()));
                if (invoice.getCash() > 0.0) {
                    this.sanadAdd(PaymentDetailDto.builder().colcode(invoice.getCashsarfasl().substring(0, 3)).moiencode(invoice.getCashsarfasl().substring(3, 7)).tafzilicode(invoice.getCashsarfasl().substring(7)).bes(Double.valueOf(invoice.getCash())).typeline("Z").commentline(invoiceTypeName + " " + invoice.getCode() + '-' + invoice.getCustomername()));
                }
                if (invoice.getBank() > 0.0) {
                    this.sanadAdd(PaymentDetailDto.builder().colcode(invoice.getBanksarfasl().substring(0, 3)).moiencode(invoice.getBanksarfasl().substring(3, 7)).tafzilicode(invoice.fetchBankTafsili()).bes(Double.valueOf(invoice.getBank())).typeline("Z").commentline(invoiceTypeName + " " + invoice.getCode() + '-' + invoice.getCustomername()));
                }
                if (invoice.getPosinfos() != null) {
                    for (Object posInfo : invoice.getPosinfos()) {
                        this.sanadAdd(PaymentDetailDto.builder().colcode(posInfo.getBanksarfasl().substring(0, 3)).moiencode(posInfo.getBanksarfasl().substring(3, 7)).tafzilicode(posInfo.fetchBankTafsili()).bes(Double.valueOf(posInfo.getBank())).typeline("Z").commentline(invoiceTypeName + " " + invoice.getCode() + '-' + invoice.getCustomername()));
                    }
                }
                if (!(invoice.getDiscount() > 0.0)) break;
                String defaultSarfasl = "9030001";
                if (this.settingDao.getMSetup2Boolean(myLogin, "ConvertNewSarfasl")) {
                    defaultSarfasl = "6030001";
                }
                String discountY = this.settingDao.getMSetup2String(myLogin, "BarghashtForush", defaultSarfasl);
                this.sanadAdd(PaymentDetailDto.builder().colcode(discountY.substring(0, 3)).moiencode(discountY.substring(3, 7)).tafzilicode(discountY.substring(7)).bes(Double.valueOf(invoice.getDiscount())).typeline("Z").commentline("\u0628\u0627\u0628\u062a \u0641\u0627\u0643\u062a\u0648\u0631 " + invoice.getCode() + " " + invoice.getCustomername()));
                if (!settingLoader.SaveCustForVaseteh() || invoice.getVaseteh() == null) break;
                this.insertToSndListSaveForCustPorsant(invoice, (JdbcTemplate)jdbcTemplate, invoiceTypeName);
                break;
            }
        }
        this.sndList.addAll(commissionCalculator.getCommissionSndListData());
        commissionCalculator.updateFactArt();
        for (int h = 0; h <= this.sndList.size() - 1; ++h) {
            boolean isKartabl = myLogin.getSuperVizor() == false && settingLoader.kartablFactureForUser();
            int showDaftar = 1;
            if (isKartabl) {
                switch (showDaftar) {
                    case 1: {
                        if (invoice.getInvoiceType().getCode() == 1 && settingLoader.kartablFactForosh()) {
                            showDaftar = 0;
                        }
                    }
                    case 2: {
                        if (invoice.getInvoiceType().getCode() == 2 && settingLoader.kartablFactBargashtForosh()) {
                            showDaftar = 0;
                        }
                    }
                    case 3: {
                        if (invoice.getInvoiceType().getCode() == 3 && settingLoader.kartablFactKharid()) {
                            showDaftar = 0;
                        }
                    }
                    case 4: {
                        if (invoice.getInvoiceType().getCode() != 4 || !settingLoader.kartablFactBargashtKharid()) break;
                        showDaftar = 0;
                    }
                }
            }
            sqlStr = " Insert Into Snd_List(Sanad_Code, Col_Code, Moien_Code, Tafzili_Code, Bed, Bes, Joze, Show_Daftar,Type_Line, Comment_Line, Actions, Number_Line)  Values(" + sanadCode + ",'" + ((PaymentDetailDto)this.sndList.get(h)).getColcode() + "','" + ((PaymentDetailDto)this.sndList.get(h)).getMoiencode() + "','" + ((PaymentDetailDto)this.sndList.get(h)).getTafzilicode() + "'," + ((PaymentDetailDto)this.sndList.get(h)).getBed() + "," + ((PaymentDetailDto)this.sndList.get(h)).getBes() + "," + ConvertStr.getBoolToInt((Boolean)((PaymentDetailDto)this.sndList.get(h)).getJoze()) + "," + showDaftar + ",'" + ((PaymentDetailDto)this.sndList.get(h)).getTypeline() + "', N'" + ((PaymentDetailDto)this.sndList.get(h)).getCommentline() + "'," + ((PaymentDetailDto)this.sndList.get(h)).getActions() + "," + ((PaymentDetailDto)this.sndList.get(h)).getNumberline() + ")";
            jdbcTemplate.execute(sqlStr);
        }
        rs = jdbcTemplate.queryForRowSet("select Sanad_Code from FCOUNECT where fac_code = ? and fac_type = ?", new Object[]{invoice.getId(), invoice.getType()});
        if (rs.next()) {
            jdbcTemplate.update("update FCOUNECT set Sanad_Code = ? where fac_code = ? and fac_type = ?", new Object[]{sanadCode, invoice.getId(), invoice.getType()});
        }
        return sanadCode;
    }

    private double calculateTotalDiscount(InvoiceDto.InvoiceInfo invoice) {
        double totalDiscount = 0.0;
        if (invoice.getDiscount() == 0.0) {
            for (InvoiceDetailDto dtl : invoice.getDetailinfo()) {
                if (dtl.getDiscountprice() == null && dtl.getDiscountpercent() != null) {
                    totalDiscount += dtl.getPrice() * dtl.getFew() * (dtl.getDiscountpercent() / 100.0);
                    continue;
                }
                if (dtl.getDiscountprice() == null || dtl.getDiscountpercent() != null) continue;
                totalDiscount += dtl.getDiscountprice().doubleValue();
            }
        }
        return totalDiscount;
    }

    @NotNull
    private String makeReceivedSanadComment(InvoiceDto.InvoiceInfo invoice, String invoiceTypeName, double bank) {
        String Comment;
        String string = Comment = this.isInvoice(invoice.getRegisterType()) ? "\u062f\u0631\u06cc\u0627\u0641\u062a \u0628\u0647 \u0635\u0648\u0631\u062a \u06a9\u0627\u0631\u062a \u0646\u0642\u062f \u0628\u0627\u0628\u062a \u0633\u0641\u0627\u0631\u0634  " + invoiceTypeName : "\u062c\u0645\u0639 \u062f\u0631\u064a\u0627\u0641\u062a\u064a \u0628\u0627\u0628\u062a " + invoiceTypeName;
        if (invoice.getDiscount() > 0.0) {
            Comment = invoice.getCash() + bank + invoice.getSumcheck() == 0.0 ? "\u062a\u062e\u0641\u064a\u0641 \u0628\u0627\u0628\u062a " + invoiceTypeName : "\u062c\u0645\u0639 \u062f\u0631\u064a\u0627\u0641\u062a\u064a \u0628\u0647 \u0627\u0646\u0636\u0645\u0627\u0645 \u062a\u062e\u0641\u064a\u0641 \u0628\u0627\u0628\u062a " + invoiceTypeName;
        }
        return Comment;
    }

    @NotNull
    private String makePaidSanadComment(InvoiceDto.InvoiceInfo invoice, String invoiceTypeName, double bank) {
        String Comment;
        String string = Comment = invoice.getType().equals("K") ? "\u062c\u0645\u0639 \u067e\u0631\u062f\u0627\u062e\u062a\u0647\u0627 \u0628\u0627\u0628\u062a " + invoiceTypeName : " \u067e\u0631\u062f\u0627\u062e\u062a \u0628\u0635\u0648\u0631\u062a \u0643\u0627\u0631\u062a \u0646\u0642\u062f  \u0628\u0627\u0628\u062a \u0633\u0641\u0627\u0631\u0634  " + invoiceTypeName;
        if (invoice.getDiscount() > 0.0) {
            Comment = invoice.getCash() + bank + invoice.getSumcheck() == 0.0 ? "\u062a\u062e\u0641\u064a\u0641 \u0628\u0627\u0628\u062a " + invoiceTypeName : "\u062c\u0645\u0639 \u067e\u0631\u062f\u0627\u062e\u062a\u0647\u0627 \u0628\u0647 \u0627\u0646\u0636\u0645\u0627\u0645 \u062a\u062e\u0641\u064a\u0641 \u0628\u0627\u0628\u062a " + invoiceTypeName;
        }
        return Comment;
    }

    private String getTorfehNegarInvCode(TncJdbc jdbcTemplate, InvoiceType invoiceType) {
        SqlRowSet rs = jdbcTemplate.queryForRowSet("exec dbo.CMS_GetMaxFactCode '" + invoiceType.getSymbol() + "'");
        rs.next();
        return rs.getString("Fact_Code");
    }

    private void addSanadCheck(PaymentDto payment, InvoiceDto.InvoiceInfo invoice) {
        String comment;
        String string = comment = invoice.getType().equals("F") ? "\u062f\u0631\u06cc\u0627\u0641\u062a \u0686\u06a9 \u0628\u0627\u0628\u062a " : "\u067e\u0631\u062f\u0627\u062e\u062a \u0686\u06a9  ";
        if (!ConvertStr.isNullOrEmpty((Collection)payment.getChecks())) {
            for (CheckDto check : payment.getChecks()) {
                this.sanadAdd(PaymentDetailDto.builder().colcode(check.getCheckSarfasl().substring(0, 3)).moiencode(check.getCheckSarfasl().substring(3, 7)).tafzilicode(check.getCheckSarfasl().substring(7)).bes(Double.valueOf(invoice.getType().equals("F") ? 0.0 : check.getCust())).bed(Double.valueOf(invoice.getType().equals("F") ? check.getCust() : 0.0)).typeline("Z").numberline(Double.valueOf(check.getCheckcode())).commentline(comment + invoice.getInvoiceType().getFarsiName() + " " + invoice.getCode() + " " + invoice.getCustomername()));
            }
        }
    }

    private void checkDuplicateInvoiceCustomCode(int invCustCode, String facType, JdbcTemplate jdbcTemplate) throws TncException {
        Integer count = (Integer)jdbcTemplate.queryForObject(" SELECT COUNT(*) cnt FROM FACTURE WHERE FAC_CODE_C = ? AND Fac_Type = ?", Integer.class, new Object[]{invCustCode, facType});
        if (ConvertStr.nullSafeInt((Integer)count) > 0) {
            throw new TncException(TncExceptionMessages.DUPLICATE_INVOICE_CODE.setArgs(new Object[]{invCustCode}));
        }
    }

    private int generateInvoiceCustomCode(LoginDto myLogin, JdbcTemplate jdbcTemplate, InvoiceType invoiceType) {
        if (myLogin.getIsTorfehNegar().booleanValue()) {
            return this.getTorfehNegarInvCodeC(jdbcTemplate, invoiceType);
        }
        String sqlStr = this.settingDao.getMSetup2Boolean(myLogin, "MaxFac_Code_C") ? "SELECT ISNULL(MAX(FAC_CODE_C),0)+1 FAC_CODE_C FROM FACTURE WHERE FAC_TYPE= ?" : "SELECT ISNULL((SELECT TOP 1 FAC_CODE_C FROM FACTURE WHERE FAC_TYPE= ?  ORDER BY FAC_CODE DESC, FAC_TYPE) , 0) + 1 FAC_CODE_C";
        SqlRowSet rs = jdbcTemplate.queryForRowSet(sqlStr, new Object[]{invoiceType.getSymbol()});
        if (rs.next()) {
            return rs.getInt("FAC_CODE_C");
        }
        return 0;
    }

    private int getTorfehNegarInvCodeC(JdbcTemplate jdbcTemplate, InvoiceType invoiceType) {
        SqlRowSet rs = jdbcTemplate.queryForRowSet("exec dbo.CMS_GetMaxFactCode '" + invoiceType.getSymbol() + "'");
        rs.next();
        return rs.getInt("Fact_Code_C");
    }

    private void insertToSndListSaveForCustPorsant(InvoiceDto.InvoiceInfo invoice, JdbcTemplate jdbcTemplate, String invoiceTypeName) {
        SqlRowSet res;
        StringBuilder nameVaseteh = new StringBuilder();
        String bedCol = "";
        String bedMoien = "";
        String bedTafzili = "";
        String besCol = "";
        String besMoien = "";
        String besTafzili = "";
        String sarfaslCode = "";
        double sumCustPorsant = 0.0;
        for (int i = 0; i < invoice.getVaseteh().size(); ++i) {
            res = jdbcTemplate.queryForRowSet("select c_name,Col_Code_Bed ,Moien_Code_Bed,Tafzili_Code_Bed, Col_Code_Bes,Moien_Code_Bes,Tafzili_Code_Bes from customer where c_code = ?", new Object[]{ConvertStr.decrypt((String)((InvoiceVasetehDto)invoice.getVaseteh().get(i)).getMidmanerpcode())});
            if (res.next()) {
                nameVaseteh.append(res.getString("c_name"));
                bedCol = res.getString("Col_Code_Bed");
                bedMoien = res.getString("Moien_Code_Bed");
                bedTafzili = res.getString("Tafzili_Code_Bed");
                besCol = res.getString("Col_Code_Bes");
                besMoien = res.getString("Moien_Code_Bes");
                besTafzili = res.getString("Tafzili_Code_Bes");
            }
            res = jdbcTemplate.queryForRowSet("select Cust_Porsunt from FCOUNECT where fac_code = ? and Fac_Type = ? and Counect_Code = ?", new Object[]{invoice.getId(), invoice.getType(), ConvertStr.decrypt((String)((InvoiceVasetehDto)invoice.getVaseteh().get(i)).getMidmanerpcode())});
            nameVaseteh.append("-");
            this.sanadAdd(PaymentDetailDto.builder().colcode(besCol.isEmpty() ? bedCol : besCol).moiencode(besCol.isEmpty() ? bedMoien : besMoien).tafzilicode(besCol.isEmpty() ? bedTafzili : besTafzili).bes(Double.valueOf(res.next() ? res.getDouble("Cust_Porsunt") : 0.0)).commentline(" \u0643\u0645\u064a\u0633\u064a\u0648\u0646 " + invoiceTypeName + " " + invoice.getCode() + " - " + invoice.getCustomername()));
        }
        res = jdbcTemplate.queryForRowSet("select SarFasl_Code ,sum(Cust_Porsunt)sum from FCOUNECT where fac_code = ? and Fac_Type = ? group by SarFasl_Code", new Object[]{invoice.getId(), invoice.getType()});
        while (res.next()) {
            sarfaslCode = res.getString("Sarfasl_Code");
            sumCustPorsant = res.getDouble("sum");
            this.sanadAdd(PaymentDetailDto.builder().bed(Double.valueOf(sumCustPorsant)).colcode(sarfaslCode.substring(0, 3)).moiencode(sarfaslCode.substring(3)).commentline(nameVaseteh + " \u0641\u0627\u06a9\u062a\u0648\u0631" + invoice.getCode()));
        }
    }

    private void checkDuplicateWebId(LoginDto login, String inputId, int fRegisterType, String invoiceType) throws TncException {
        String table;
        String type = null;
        if (this.isInvoice(fRegisterType) && !login.getIsMyHoloo().booleanValue()) {
            table = "FACTURE";
            type = "Fac_Type";
        } else if (this.isInvoice(fRegisterType) && login.getIsMyHoloo().booleanValue()) {
            table = "TmpFacture";
            type = "FType";
        } else if (this.isOrder(fRegisterType)) {
            table = "RqTitle";
            type = "RqType";
        } else if (this.isPreInvoice(fRegisterType)) {
            table = "FBailPre";
            type = "Fac_Type";
        } else {
            table = null;
        }
        if (table == null) {
            return;
        }
        String sql = "SELECT COUNT(*) FROM " + table + " WHERE WebId = '" + inputId + "' AND " + type + " = '" + invoiceType + "'";
        Integer webIdCount = (Integer)this.dbConnection.getJdbcTemplate(login).queryForObject(sql, Integer.class);
        if (webIdCount != null && webIdCount > 0) {
            throw new TncException(TncExceptionMessages.DUPLICATE_WEB_ID);
        }
    }

    private void insertCustomerAddress(JdbcTemplate jdbcTemplate, InvoiceDto.InvoiceInfo invoice) {
        if (!ConvertStr.isNullOrEmpty((String)invoice.getCustomeraddress()) && invoice.getCustomeraddressid() < 1) {
            throw new TncException(TncExceptionMessages.USE_CUSTOMER_ADDRESS_ID_INSTEAD);
        }
        String sql = invoice.getCustomeraddressid() == 1 || invoice.getCustomeraddressid() == 0 ? "SELECT C_ADDRESS cAddress FROM CUSTOMER WHERE C_CODE = '" + invoice.getCustomerid() + "'" : "SELECT C_ADDRESS" + (invoice.getCustomeraddressid() - 1) + " cAddress FROM CUST_TELL \n WHERE CCode = '" + invoice.getCustomerid() + "'";
        SqlRowSet rs = jdbcTemplate.queryForRowSet(sql);
        boolean hasAddress = rs.next();
        if ((!hasAddress || ConvertStr.isNullOrEmpty((String)rs.getString("cAddress"))) && invoice.getCustomeraddressid() != 0) {
            throw new TncException(TncExceptionMessages.INVALID_CUSTOMER_ADDRESS_ID);
        }
        invoice.setCustomeraddress(hasAddress ? ConvertStr.nullSafeString((String)rs.getString("cAddress")) : "");
        jdbcTemplate.update(" INSERT INTO FactOther (FAC_CODE, FAC_TYPE, C_NAME, C_ADDRESS, ADDRESS_ID, \n TELL_ID, MOBILE_ID, C_CODE) VALUES (?, ?, ?, ?, ?, ?, ?, ?)", new Object[]{invoice.getId(), invoice.getType(), invoice.getCustomername(), invoice.getCustomeraddress(), invoice.getCustomeraddressid() == 0 ? 1 : invoice.getCustomeraddressid(), 0, 0, invoice.getCustomerid()});
    }

    private void addPoshak(LoginDto login, int fRegisterType, InvoiceDto.InvoiceInfo invoiceInfo, int index, InvoiceDetailDto dtl) {
        if (dtl.getPoshakinfo() == null) {
            return;
        }
        String pType = invoiceInfo.getType();
        if (!login.getIsMyHoloo().booleanValue()) {
            if (this.isOrder(fRegisterType)) {
                pType = "J";
            } else if (this.isPreInvoice(fRegisterType)) {
                pType = "P";
            }
        } else if (this.isInvoice(fRegisterType)) {
            pType = "T";
        }
        StringBuilder pComment = new StringBuilder();
        for (ProductCategory myProductCategoryClass : dtl.getPoshakinfo()) {
            if (this.isInvoice(fRegisterType) && !login.getIsMyHoloo().booleanValue()) {
                this.itemArticleDao.updateItemArticleFew(login, myProductCategoryClass, dtl.getProductid(), invoiceInfo.getInvoiceType().getOperator());
            }
            this.itemArticleDao.insertItemFact(login, invoiceInfo.getId(), pType, dtl.getProductid(), myProductCategoryClass, index);
            if (!ConvertStr.isNullOrEmpty((String)dtl.getComment())) continue;
            pComment = this.itemArticleDao.getAttributeNameTree(myProductCategoryClass, pComment, login);
        }
        this.updatePoshakInvoiceComment(login, fRegisterType, invoiceInfo, index, dtl, pComment, pType);
    }

    private void updatePoshakInvoiceComment(LoginDto login, int fRegisterType, InvoiceDto.InvoiceInfo invoiceInfo, int index, InvoiceDetailDto dtl, StringBuilder pComment, String pType) {
        if (!ConvertStr.isNullOrEmpty((String)dtl.getComment()) || pComment.toString().isEmpty()) {
            return;
        }
        String sqlStr = this.isOrder(fRegisterType) ? " Update RqDetail Set R_Commen = '" + pComment + "' Where RqIndex=" + invoiceInfo.getId() + " And RqType='" + invoiceInfo.getType() + "' And R_ArCode='" + dtl.getProductid() + "'" : (this.isPreInvoice(fRegisterType) ? " Update Abailpre Set FacArtic_Comment = '" + pComment + "' Where Fac_Code='" + invoiceInfo.getId() + "' And Fac_Type='" + pType + "' And A_Code='" + dtl.getProductid() + "' And A_Index=" + (index + 1) : " Update Factart Set FacArtic_Comment = '" + pComment + "' Where Fac_Code='" + invoiceInfo.getId() + "' And Fac_Type='" + pType + "' And A_Code='" + dtl.getProductid() + "' And A_Index=" + (index + 1));
        this.dbConnection.getJdbcTemplate(login).execute(sqlStr);
    }

    private void addPoshakMyHoloo(LoginDto myLogin, int fRegisterType, InvoiceDto.InvoiceInfo invoiceInfo, int index, InvoiceDetailDto dtl) {
        String pType;
        if (dtl.getPoshakinfo() == null) {
            return;
        }
        if (fRegisterType != 2) {
            return;
        }
        switch (invoiceInfo.getType()) {
            case "F": {
                pType = "6";
                break;
            }
            case "K": {
                pType = "5";
                break;
            }
            case "Y": {
                pType = "8";
                break;
            }
            default: {
                return;
            }
        }
        StringBuilder pComment = new StringBuilder();
        for (int k = 0; k < dtl.getPoshakinfo().size(); ++k) {
            ProductCategory myProductCategoryClass = (ProductCategory)dtl.getPoshakinfo().get(k);
            this.itemArticleDao.insertItemFact(myLogin, invoiceInfo.getId(), pType, dtl.getProductid(), myProductCategoryClass, index, true);
            if (!ConvertStr.isNullOrEmpty((String)dtl.getComment())) continue;
            pComment = this.itemArticleDao.getAttributeNameTree(myProductCategoryClass, pComment, myLogin);
        }
        if (!ConvertStr.isNullOrEmpty((String)dtl.getComment()) || pComment.toString().isEmpty()) {
            return;
        }
        String sqlStr = " UPDATE TMPFACTART SET A_COMMENT = '" + pComment + "' WHERE IDFACTURE='" + invoiceInfo.getId() + "' AND A_CODE='" + dtl.getProductid() + "'";
        this.dbConnection.getJdbcTemplate(myLogin).execute(sqlStr);
    }

    private void checkExistPoshak(boolean negativeOfSath, InvoiceDto.InvoiceInfo invoiceInfo, List<Map<String, Object>> myProduct, InvoiceDetailDto myDtlClass, LoginDto myLogin) throws TncException {
        if (myDtlClass.getPoshakinfo() == null) {
            return;
        }
        for (int k = 0; k < myDtlClass.getPoshakinfo().size(); ++k) {
            ProductCategory myProductCategoryClass = (ProductCategory)myDtlClass.getPoshakinfo().get(k);
            if (myProductCategoryClass.getFew() == null || myProductCategoryClass.getFew() <= 0.0) {
                LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
                model.put("ErpCode", myDtlClass.getProducterpcode());
                model.put("Id", myProductCategoryClass.getId());
                myProduct.add(model);
                throw new TncException(TncExceptionMessages.INVALID_ATTRIBUTE_AMOUNT);
            }
            if (this.itemArticleDao.getAttribCountByProductAndPoshakId(myDtlClass.getProductid(), myProductCategoryClass.getId().intValue(), myLogin) == 0) {
                LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
                model.put("ErpCode", myDtlClass.getProducterpcode());
                model.put("Id", myProductCategoryClass.getId());
                myProduct.add(model);
                throw new TncException(TncExceptionMessages.INVALID_ATTRIBUTE_CODES);
            }
            if (!this.negativeSathNotAllowed(negativeOfSath, invoiceInfo)) continue;
            double poshakAmount = this.itemArticleDao.getAttribFewByProductAndPoshakId(myDtlClass.getProductid(), myProductCategoryClass.getId().intValue(), myLogin);
            if (!(myProductCategoryClass.getFew() > poshakAmount)) continue;
            LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
            model.put("ErpCode", myDtlClass.getProducterpcode());
            model.put("Id", myProductCategoryClass.getId());
            model.put("Few", poshakAmount);
            myProduct.add(model);
            throw new TncException(TncExceptionMessages.ATTRIBUTES_NO_STORE);
        }
    }

    private boolean negativeInvoiceNotAllowed(boolean negativeFact, InvoiceDto.InvoiceInfo invoiceInfo) {
        if (invoiceInfo.getType().equals("F") || invoiceInfo.getType().equals("X")) {
            return !negativeFact;
        }
        return false;
    }

    private boolean negativeSathNotAllowed(boolean negativeFact, InvoiceDto.InvoiceInfo invoiceInfo) {
        if (invoiceInfo.getType().equals("F") || invoiceInfo.getType().equals("X") || invoiceInfo.getType().equals("P")) {
            return !negativeFact;
        }
        return false;
    }

    private boolean negativePishNotAllowed(boolean negativePish, InvoiceDto.InvoiceInfo invoiceInfo) {
        if (invoiceInfo.getType().equals("P")) {
            return !negativePish;
        }
        return false;
    }

    private boolean isInvoice(int fRegisterType) {
        return fRegisterType == 2;
    }

    private boolean isPreInvoice(int fRegisterType) {
        return fRegisterType == 1;
    }

    private boolean isOrder(int fRegisterType) {
        return fRegisterType == 0;
    }

    private boolean isInvoiceOrPreInvoice(int fRegisterType) {
        return this.isPreInvoice(fRegisterType) || this.isInvoice(fRegisterType);
    }

    private boolean isOrderOrInvoice(int fRegisterType) {
        return this.isInvoice(fRegisterType) || this.isOrder(fRegisterType);
    }

    private boolean isCostAvailable(InvoiceDto.InvoiceInfo invoice) {
        return !ConvertStr.isNullOrEmpty((Collection)invoice.getHazineinfo()) && (invoice.getType().equals("F") || invoice.getType().equals("K"));
    }

    private boolean isIncomeAvailable(InvoiceDto.InvoiceInfo invoice) {
        return !ConvertStr.isNullOrEmpty((Collection)invoice.getIncomeinfo()) && (invoice.getType().equals("F") || invoice.getType().equals("K"));
    }

    private void serialOperations(InvoiceDto.InvoiceInfo invoice, LoginDto myLogin) throws TncException {
        for (InvoiceDetailDto dtl : invoice.getDetailinfo()) {
            dtl.setType(invoice.getType());
            SerialDao serialDao = new SerialDao(this.dbConnection, dtl, myLogin);
            serialDao.assertMustHaveSerial();
            serialDao.assertAnbSerExistence();
            if (ConvertStr.isNullOrEmpty((Collection)dtl.getSerials())) continue;
            serialDao.buyOrSellGivenSerials(invoice.getId());
        }
    }

    private ResponseEntity<Map<String, Object>> postInvoiceListOnly(LoginDto myLogin, InvoiceDto.InvoiceInfo[] invoiceInfo) {
        ArrayList<Map> failure = new ArrayList<Map>();
        ArrayList success = new ArrayList();
        try {
            this.insertOrDeleteInvoice(myLogin, invoiceInfo);
        }
        catch (Exception ex) {
            TncException exception = new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
            failure.add(exception.makeErrorWithCause((Throwable)ex));
            return ConvertStr.getMapResponseEntity((String)"Invoice", failure, success);
        }
        LinkedHashMap<String, Boolean> model = new LinkedHashMap<String, Boolean>();
        model.put("Success", true);
        success.add(model);
        return ConvertStr.getMapResponseEntity((String)"Invoice", failure, success);
    }

    void insertOrDeleteInvoice(LoginDto myLogin, InvoiceDto.InvoiceInfo[] invoiceInfo) {
        try {
            TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)myLogin.getDatabaseName()).transactionDeadLockWrapper(() -> this.insertInvoice(myLogin, invoiceInfo), new String[]{"FACTURE", "FACTART"});
        }
        catch (Exception ex) {
            this.deleteRepeatInvoice(myLogin, invoiceInfo);
            if (ConvertStr.exceptionContains((Exception)ex, (String)"duplicate key")) {
                this.insertOrDeleteInvoice(myLogin, invoiceInfo);
            }
            throw ex;
        }
    }

    private void insertInvoice(LoginDto myLogin, InvoiceDto.InvoiceInfo[] invoiceArray) {
        int m = 0;
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
        StringBuilder sb = new StringBuilder();
        for (InvoiceDto.InvoiceInfo info : invoiceArray) {
            ++m;
            if (sb.length() > 0) {
                sb.append(" , ");
            }
            this.appendSelectFactureStatement(sb, info);
            if (m <= 50) continue;
            sb = this.getInsertFactureStatement().append("values ").append((CharSequence)sb);
            jdbcTemplate.execute("\n" + sb + "\n");
            m = 0;
            sb.delete(0, sb.length());
        }
        if (m > 0) {
            sb = this.getInsertFactureStatement().append("values ").append((CharSequence)sb);
            jdbcTemplate.execute("\n" + sb + "\n");
        }
        m = 0;
        sb.delete(0, sb.length());
        for (InvoiceDto.InvoiceInfo info : invoiceArray) {
            for (int j = 0; j < info.getDetailinfo().size(); ++j) {
                InvoiceDetailDto dtl = (InvoiceDetailDto)info.getDetailinfo().get(j);
                ++m;
                if (sb.length() > 0) {
                    sb.append(" , ");
                }
                if (ConvertStr.isNullOrEmpty((String)dtl.getType())) {
                    dtl.setType(info.getType());
                }
                if (dtl.getAindex() == null) {
                    dtl.setAindex(Integer.valueOf(j + 1));
                }
                this.appendSelectFactartStatement(sb, dtl);
                if (m <= 50) continue;
                sb = this.getInsertFactartStatement().append("values ").append((CharSequence)sb);
                jdbcTemplate.execute(sb.toString());
                m = 0;
                sb.delete(0, sb.length());
            }
        }
        if (m > 0) {
            sb = this.getInsertFactartStatement().append("values ").append((CharSequence)sb);
            jdbcTemplate.execute(sb.toString());
        }
    }

    private void deleteRepeatInvoice(LoginDto myLogin, InvoiceDto.InvoiceInfo[] invoiceArray) {
        TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)myLogin.getDatabaseName()).transactionDeadLockWrapper(() -> {
            TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
            int i = 0;
            while (i < invoiceArray.length) {
                StringBuilder Fac_Code = new StringBuilder("'" + invoiceArray[i].getFac_code() + invoiceArray[i].getType() + "'");
                ++i;
                for (int j = 0; j < 50 && i < invoiceArray.length; ++j, ++i) {
                    Fac_Code.append(",'").append(invoiceArray[i].getFac_code()).append(invoiceArray[i].getType()).append("'");
                }
                jdbcTemplate.execute(" Delete Facture Where Fac_Code + Fac_Type in (" + Fac_Code + ")");
                jdbcTemplate.execute(" Delete Factart Where Fac_Code + Fac_Type in (" + Fac_Code + ")");
            }
        }, new String[]{"FACTURE", "FACTART"});
    }

    private void deleteInvoice(LoginDto myLogin, InvoiceDto.InvoiceInfo invoiceInfo, int FRegisterType, Request request) {
        String operator;
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
        SqlRowSet rs = jdbcTemplate.queryForRowSet("select few_article, A_Code,Few_Article2 from factart where fac_code = ? and fac_type = ?", new Object[]{invoiceInfo.getId(), invoiceInfo.getType()});
        String clc = invoiceInfo.getInvoiceType().getOperator();
        String string = operator = clc.equals("+") ? "-" : "+";
        while (rs.next()) {
            double few = rs.getDouble("few_article");
            double FewKarton = rs.getDouble("Few_Article2");
            String aCode = rs.getString("A_Code");
            String sqlStr = "";
            sqlStr = "Update Article Set Exist = Exist " + operator + few + " , Exist_Mandeh  = Exist_Mandeh " + operator + few + " , Exist2  = Exist2 " + operator + FewKarton + " Where A_Code = '" + aCode + "'";
            jdbcTemplate.execute(sqlStr);
        }
        if (this.isOrder(FRegisterType)) {
            jdbcTemplate.execute("Delete From RQTITLE where rqindex =  " + invoiceInfo.getId() + " and rqtype = '" + invoiceInfo.getType() + "'");
            jdbcTemplate.execute("Delete From RQDETAIL where rqindex =  " + invoiceInfo.getId() + " and rqtype = '" + invoiceInfo.getType() + "'");
            if (invoiceInfo.getCash() + invoiceInfo.getBank() <= 0.0) {
                jdbcTemplate.execute("Delete From sanad where Sanad_Code =  " + invoiceInfo.getSanadcode());
            }
        } else if (this.isInvoice(FRegisterType)) {
            jdbcTemplate.execute("Delete From Facture where Fac_Code =  " + invoiceInfo.getId() + " and Fac_Type = '" + invoiceInfo.getType() + "'");
            jdbcTemplate.execute("Delete From Factart where Fac_Code =  " + invoiceInfo.getId() + " and Fac_Type = '" + invoiceInfo.getType() + "'");
            jdbcTemplate.execute("Delete From FCOUNECT where Fac_Code =  " + invoiceInfo.getId() + " and Fac_Type = '" + invoiceInfo.getType() + "'");
        }
        jdbcTemplate.execute("Delete From FactOther where Fac_Code =  " + invoiceInfo.getId() + " and Fac_Type = '" + invoiceInfo.getType() + "'");
        jdbcTemplate.execute("Delete From SND_LIST where Sanad_Code =  " + invoiceInfo.getSanadcode());
        jdbcTemplate.execute("Delete From SND_INDX where Sanad_Code =  " + invoiceInfo.getSanadcode());
        if (request.equals((Object)Request.DELETE)) {
            jdbcTemplate.execute("Delete From sanad where Sanad_Code =  " + invoiceInfo.getSanadcode());
        }
    }

    private String filterTmpInvoice(HttpServletRequest request) {
        Map info = ConvertStr.rebuildQueryString((HttpServletRequest)request);
        String[] infos = new String[]{"ischange", "isdeleted"};
        StringBuilder sqlWhere = new StringBuilder();
        for (String i : infos) {
            if (!info.containsKey(i)) continue;
            if (sqlWhere.length() != 0) {
                sqlWhere.append(" AND ");
            }
            sqlWhere.append("f.").append(i).append(" = '").append((String)info.get(i)).append("'");
        }
        if (sqlWhere.length() > 0) {
            sqlWhere.insert(0, " Where ");
        }
        return sqlWhere.toString();
    }

    private String getFilter(Map<String, String> info) {
        String sqlWhere = "";
        SearchQuery searchQuery = new SearchQuery();
        int Type2 = 0;
        if (info.containsKey("type")) {
            Type2 = Integer.parseInt(info.get("type"));
            sqlWhere = Type2 == 6 || Type2 == 8 ? sqlWhere + " f.RqType ='" + ConvertStr.getTypeOfFacture((String)info.get("type")) + "'" : sqlWhere + " f.Fac_Type ='" + ConvertStr.getTypeOfFacture((String)info.get("type")) + "'";
        }
        if (info.containsKey("customererpcode")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = Type2 == 6 || Type2 == 8 ? sqlWhere + " f.R_CUSCODE = '" + ConvertStr.decrypt((String)info.get("customererpcode")) + "'" : sqlWhere + " f.C_CODE = '" + ConvertStr.decrypt((String)info.get("customererpcode")) + "'";
        }
        if (info.containsKey("erpcode") && Type2 != 6 && Type2 != 8) {
            String query = searchQuery.makeSqlQueryNoTextSearch(info.get("erpcode"), "FAC_CODE", "f", ParamType.DECRYPT);
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + query;
        }
        if (info.containsKey("code")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = Type2 == 6 || Type2 == 8 ? sqlWhere + " f.RqIndex2 = '" + info.get("code") + "'" : sqlWhere + " f.Fac_code_c = '" + info.get("code") + "'";
        }
        if (info.containsKey("code.from")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = Type2 == 6 || Type2 == 8 ? sqlWhere + " f.RqIndex2 >= '" + info.get("code.from") + "'" : sqlWhere + " f.Fac_code_c >= '" + info.get("code.from") + "'";
        }
        if (info.containsKey("code.to")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = Type2 == 6 || Type2 == 8 ? sqlWhere + " f.RqIndex2 <= '" + info.get("code.to") + "'" : sqlWhere + " f.Fac_code_c <= '" + info.get("code.to") + "'";
        }
        if (Type2 != 6 && Type2 != 8 && info.containsKey("sanadcode")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " S.Sanad_Code_C = '" + info.get("sanadcode") + "'";
        }
        if (Type2 != 6 && Type2 != 8 && info.containsKey("sanadcode.from")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " S.Sanad_Code_C >= '" + info.get("sanadcode.from") + "'";
        }
        if (Type2 != 6 && Type2 != 8 && info.containsKey("sanadcode.to")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " S.Sanad_Code_C <= '" + info.get("sanadcode.to") + "'";
        }
        if (info.containsKey("date")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = Type2 == 6 || Type2 == 8 ? sqlWhere + " f.T_date = '" + info.get("date") + "'" : sqlWhere + " f.Fac_date = '" + info.get("date") + "'";
        }
        if (info.containsKey("date.from")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = Type2 == 6 || Type2 == 8 ? sqlWhere + " f.T_date >= '" + info.get("date.from") + "'" : sqlWhere + " f.Fac_date >= '" + info.get("date.from") + "'";
        }
        if (info.containsKey("date.to")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = Type2 == 6 || Type2 == 8 ? sqlWhere + " f.T_date <= '" + info.get("date.to") + "'" : sqlWhere + " f.Fac_date <= '" + info.get("date.to") + "'";
        }
        if (info.containsKey("web-id")) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + searchQuery.makeSqlQueryNoTextSearch(info.get("web-id"), "webId", "f");
        }
        if (!sqlWhere.isEmpty()) {
            sqlWhere = " Where " + sqlWhere;
        }
        return sqlWhere;
    }

    public synchronized ResponseEntity<?> postSmartHelpOrder(String body) {
        List<Object> orderInfo;
        LoginDto myLogin = this.dbConnection.setToken();
        ArrayList<Map> failure = new ArrayList<Map>();
        ArrayList success = new ArrayList();
        try {
            body = body.substring(15, body.length() - 1);
            Gson gson = new Gson();
            orderInfo = Arrays.asList((Object[])gson.fromJson(body, OrderDto.OrderInfo[].class));
        }
        catch (Exception ex) {
            TncException e = new TncException(TncExceptionMessages.WRONG_JSON_STRUCT);
            if (myLogin.getIsTorfehNegar().booleanValue()) {
                e.putMoreInfo("ErrorMessage", (Object)ex.getMessage());
            }
            failure.add(e.getErrorMap());
            return ConvertStr.getMapResponseEntity((String)"Order", failure, success);
        }
        try {
            this.insertOrDeleteOrder(myLogin, orderInfo);
        }
        catch (Exception ex) {
            TncException exception = new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
            failure.add(exception.makeErrorWithCause((Throwable)ex));
            return ConvertStr.getMapResponseEntity((String)"Order", failure, success);
        }
        LinkedHashMap<String, Boolean> model = new LinkedHashMap<String, Boolean>();
        model.put("Success", true);
        success.add(model);
        return ConvertStr.getMapResponseEntity((String)"Order", failure, success);
    }

    private void insertOrDeleteOrder(LoginDto myLogin, List<OrderDto.OrderInfo> orderInfos) {
        try {
            TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)myLogin.getDatabaseName()).transactionDeadLockWrapper(() -> this.batchInsertOrder(myLogin, orderInfos), new String[]{"RqTitle", "RqDetail"});
        }
        catch (Exception ex) {
            this.deleteRepeatedOrder(myLogin, orderInfos);
            if (ConvertStr.exceptionContains((Exception)ex, (String)"duplicate key")) {
                this.insertOrDeleteOrder(myLogin, orderInfos);
            }
            throw ex;
        }
    }

    private void batchInsertOrder(LoginDto myLogin, List<OrderDto.OrderInfo> orderInfos) {
        OrderBulkInsert orderInsert = new OrderBulkInsert(this.dbConnection);
        orderInsert.bulkInsert(myLogin, orderInfos);
        OrderBulkInsert.OrderDetailBulkInsert orderDtlInsert = new OrderBulkInsert.OrderDetailBulkInsert(this.dbConnection);
        ArrayList allDtls = new ArrayList();
        for (OrderDto.OrderInfo info : orderInfos) {
            allDtls.addAll(this.makeOrderDtlList(info));
        }
        orderDtlInsert.bulkInsert(myLogin, allDtls);
    }

    private List<OrderDtlDto> makeOrderDtlList(OrderDto.OrderInfo order) {
        return order.getDetailinfo().stream().peek(orderDtlDto -> {
            orderDtlDto.setRqindex(order.getRqindex());
            orderDtlDto.setRqtype(order.getRqtype());
            orderDtlDto.setIsupdate(order.getIsupdate());
        }).collect(Collectors.toList());
    }

    private void deleteRepeatedOrder(LoginDto login, List<OrderDto.OrderInfo> orderInfos) {
        TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)login.getDatabaseName()).transactionDeadLockWrapper(() -> {
            StringBuilder rqCodes = new StringBuilder();
            TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(login);
            int i = 0;
            while (i < orderInfos.size()) {
                OrderDto.OrderInfo info = (OrderDto.OrderInfo)orderInfos.get(i);
                rqCodes.delete(0, rqCodes.length());
                rqCodes.append("'").append(info.getRqindex()).append("'");
                ++i;
                for (int j = 0; j < 50 && i < orderInfos.size(); ++j, ++i) {
                    OrderDto.OrderInfo info2 = (OrderDto.OrderInfo)orderInfos.get(i);
                    rqCodes.append(",'").append(info2.getRqindex()).append("'");
                }
                jdbcTemplate.execute(" Delete RQTITLE Where RqIndex in (" + rqCodes + ")");
                jdbcTemplate.execute(" Delete RQDETAIL Where RqIndex in (" + rqCodes + ")");
            }
        }, new String[]{"RqTitle", "RqDetail"});
    }

    public synchronized ResponseEntity<?> postSmartHelpPreInvoice(String body) {
        List<Object> invoiceInfo;
        LoginDto myLogin = this.dbConnection.setToken();
        ArrayList<Map> failure = new ArrayList<Map>();
        ArrayList success = new ArrayList();
        try {
            body = body.substring(15, body.length() - 1);
            Gson gson = new Gson();
            invoiceInfo = Arrays.asList((Object[])gson.fromJson(body, InvoiceDto.InvoiceInfo[].class));
        }
        catch (Exception ex) {
            TncException e = new TncException(TncExceptionMessages.WRONG_JSON_STRUCT);
            if (myLogin.getIsTorfehNegar().booleanValue()) {
                e.putMoreInfo("ErrorMessage", (Object)ex.getMessage());
            }
            failure.add(e.getErrorMap());
            return ConvertStr.getMapResponseEntity((String)"PreInvoice", failure, success);
        }
        try {
            this.insertOrDeletePreInvoice(myLogin, invoiceInfo);
        }
        catch (Exception ex) {
            TncException exception = new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
            failure.add(exception.makeErrorWithCause((Throwable)ex));
            return ConvertStr.getMapResponseEntity((String)"PreInvoice", failure, success);
        }
        LinkedHashMap<String, Boolean> model = new LinkedHashMap<String, Boolean>();
        model.put("Success", true);
        success.add(model);
        return ConvertStr.getMapResponseEntity((String)"PreInvoice", failure, success);
    }

    private void insertOrDeletePreInvoice(LoginDto myLogin, List<InvoiceDto.InvoiceInfo> invoiceInfo) {
        try {
            TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)myLogin.getDatabaseName()).transactionDeadLockWrapper(() -> this.batchInsertPreInvoice(myLogin, invoiceInfo), new String[]{"FBailPre", "ABailPre"});
        }
        catch (Exception ex) {
            this.deleteRepeatedPreInvoice(myLogin, invoiceInfo);
            if (ConvertStr.exceptionContains((Exception)ex, (String)"duplicate key")) {
                this.insertOrDeletePreInvoice(myLogin, invoiceInfo);
            }
            throw ex;
        }
    }

    private void batchInsertPreInvoice(LoginDto myLogin, List<InvoiceDto.InvoiceInfo> invoiceInfo) {
        PreInvoiceBulkInsert preInvInsert = new PreInvoiceBulkInsert(this.dbConnection);
        preInvInsert.bulkInsert(myLogin, invoiceInfo);
        PreInvoiceBulkInsert.PreInvDtlBatchInsert preDtlInsert = new PreInvoiceBulkInsert.PreInvDtlBatchInsert(this.dbConnection);
        ArrayList allDtls = new ArrayList();
        for (InvoiceDto.InvoiceInfo info : invoiceInfo) {
            allDtls.addAll(this.makePreDtlList(info));
        }
        preDtlInsert.bulkInsert(myLogin, allDtls);
    }

    private List<InvoiceDetailDto> makePreDtlList(InvoiceDto.InvoiceInfo invoice) {
        return invoice.getDetailinfo().stream().peek(orderDtlDto -> {
            orderDtlDto.setId(invoice.getId());
            orderDtlDto.setType(invoice.getType());
            orderDtlDto.setIsupdate(invoice.getIsupdate());
        }).collect(Collectors.toList());
    }

    private void deleteRepeatedPreInvoice(LoginDto login, List<InvoiceDto.InvoiceInfo> invoiceInfo) {
        TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)login.getDatabaseName()).transactionDeadLockWrapper(() -> {
            TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(login);
            int i = 0;
            while (i < invoiceInfo.size()) {
                InvoiceDto.InvoiceInfo info = (InvoiceDto.InvoiceInfo)invoiceInfo.get(i);
                StringBuilder Fac_Code = new StringBuilder("'" + info.getFac_code() + info.getType() + "'");
                ++i;
                for (int j = 0; j < 50 && i < invoiceInfo.size(); ++j, ++i) {
                    InvoiceDto.InvoiceInfo info2 = (InvoiceDto.InvoiceInfo)invoiceInfo.get(i);
                    Fac_Code.append(",'").append(info2.getFac_code()).append(info2.getType()).append("'");
                }
                jdbcTemplate.execute(" Delete FBailPre Where Fac_Code+Fac_Type in (" + Fac_Code + ")");
                jdbcTemplate.execute(" Delete ABailPre Where Fac_Code+Fac_Type in (" + Fac_Code + ")");
            }
        }, new String[]{"FBailPre", "ABailPre"});
    }

    public ResponseEntity<?> editInvoiceTorfehnegar(List<InvoiceDto.InvoiceInfo> body) throws TncException {
        LoginDto login = this.dbConnection.setToken();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(login);
        if (!login.getIsTorfehNegar().booleanValue()) {
            return ResponseEntity.badRequest().build();
        }
        StringBuilder sb = new StringBuilder();
        for (InvoiceDto.InvoiceInfo invoice : body) {
            List facCodes = jdbcTemplate.queryForList(" SELECT FAC_CODE FROM FACTURE WHERE  FAC_CODE_C = ? AND FAC_TYPE = ?", new Object[]{invoice.getCode(), invoice.getType()});
            if (facCodes.size() != 1) {
                throw new TncException(TncExceptionMessages.DEFAULT_ERROR);
            }
            this.updateInvoiceCustomer(invoice, (JdbcTemplate)jdbcTemplate);
            this.updateDtl((JdbcTemplate)jdbcTemplate, sb, invoice, facCodes);
        }
        return ResponseEntity.ok().build();
    }

    public ResponseEntity<?> editInvoice(String body, int FRegisterType, boolean rebuildJson) throws TncException {
        LoginDto myLogin = this.dbConnection.setToken();
        if (myLogin.getIsTorfehNegar().booleanValue()) {
            try {
                List<Object> invoiceInfo = Arrays.asList((Object[])new JsonDeserializer(InvoiceDto.InvoiceInfo[].class).makeDtoArray(body, "invoiceinfo"));
                this.log.info(myLogin.getDatabaseName() + " INPUT JSON = " + body);
                return this.editInvoiceTorfehnegar(invoiceInfo);
            }
            catch (Exception ex) {
                TncException e = new TncException(TncExceptionMessages.WRONG_JSON_STRUCT);
                if (myLogin.getIsTorfehNegar().booleanValue()) {
                    e.putMoreInfo("ErrorMessage", (Object)ex.getMessage());
                }
                throw e;
            }
        }
        return this.postInvoiceList(body, FRegisterType, rebuildJson, Request.PUT);
    }

    private void updateInvoiceCustomer(InvoiceDto.InvoiceInfo invoice, JdbcTemplate jdbcTemplate) {
        if (ConvertStr.isNullOrEmpty((String)invoice.getCustomerid())) {
            return;
        }
        SqlRowSet rs = jdbcTemplate.queryForRowSet(" SELECT COMMON, SARFASL_NAME FROM SARFASL WHERE SARFASL_CODE = ?", new Object[]{invoice.getCustomerid()});
        if (rs.next()) {
            invoice.setCustid(rs.getString("COMMON"));
            invoice.setCustomername(rs.getString("SARFASL_NAME"));
        }
        String oldCustomerName = "";
        rs = jdbcTemplate.queryForRowSet(" SELECT C_NAME FROM CUSTOMER WHERE C_CODE = (SELECT C_CODE FROM FACTURE WHERE FAC_CODE_C = ? AND FAC_TYPE = ?)", new Object[]{invoice.getCode(), invoice.getType()});
        if (rs.next()) {
            oldCustomerName = rs.getString("C_NAME");
        }
        if (ConvertStr.isNullOrEmpty((String)oldCustomerName)) {
            throw new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
        }
        jdbcTemplate.update(" UPDATE FACTURE SET C_CODE = ? WHERE FAC_CODE_C = ? AND FAC_TYPE = ?", new Object[]{invoice.getCustid(), invoice.getCode(), invoice.getType()});
        rs = jdbcTemplate.queryForRowSet(" SELECT SANAD_CODE FROM FACTURE WHERE FAC_CODE_C = ? AND FAC_TYPE = ? AND C_CODE = ?", new Object[]{invoice.getCode(), invoice.getType(), invoice.getCustid()});
        if (rs.next()) {
            invoice.setSanadcode(rs.getInt("SANAD_CODE"));
        }
        String colCode = invoice.getCustomerid().substring(0, 3);
        String moeenCode = invoice.getCustomerid().substring(3, 7);
        String tafsiliCode = invoice.getCustomerid().substring(7);
        jdbcTemplate.update(" UPDATE SND_LIST SET COL_CODE = ?, MOIEN_CODE = ?, TAFZILI_CODE = ? WHERE SANAD_CODE = ? AND COL_CODE IN(SELECT DISTINCT Col_Code FROM Sarfasl WHERE Moien_code = '' AND Tafzili_Code = '' AND TYPE = 5)", new Object[]{colCode, moeenCode, tafsiliCode, invoice.getSanadcode()});
        jdbcTemplate.update(" UPDATE SND_LIST SET COMMENT_LINE = REPLACE(COMMENT_LINE, ?, ?) WHERE SANAD_CODE = ?", new Object[]{oldCustomerName, invoice.getCustomername(), invoice.getSanadcode()});
    }

    private void updateDtl(JdbcTemplate jdbcTemplate, StringBuilder sb, InvoiceDto.InvoiceInfo invoice, List<Map<String, Object>> facCodes) {
        if (invoice.getDetailinfo() == null) {
            return;
        }
        for (InvoiceDetailDto dtl : invoice.getDetailinfo()) {
            if (dtl.getFew() == null && dtl.getPrice() == null) continue;
            sb.delete(0, sb.length());
            sb.append(" UPDATE FACTART SET ");
            if (dtl.getFew() != null) {
                sb.append(" FEW_ARTICLE= ").append(dtl.getFew()).append(",");
            }
            if (dtl.getPrice() != null) {
                sb.append(" PRICE_BS= ").append(dtl.getPrice());
            }
            sb.append(" WHERE A_CODE ='").append(dtl.getProductid()).append("' AND FAC_CODE = '").append(facCodes.get(0).get("FAC_CODE")).append("'").append(" AND FAC_TYPE = '").append(invoice.getType()).append("'");
            jdbcTemplate.update(sb.toString());
        }
    }

    public synchronized ResponseEntity<? extends Map<? extends Object, ? extends Object>> deleteInvoiceLists(String[] erpCodes, Request request) {
        LoginDto login = this.dbConnection.setToken();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(login);
        ArrayList deletedErpCodes = new ArrayList();
        ArrayList errors = new ArrayList();
        HashMap failerDeletedErpCodes = new HashMap();
        ArrayList failerDelete = new ArrayList();
        HashMap successDelete = new HashMap();
        String[] decryptedCodes = new String[erpCodes.length];
        for (int i = 0; i < erpCodes.length; ++i) {
            decryptedCodes[i] = ConvertStr.decrypt((String)erpCodes[i].trim());
        }
        return (ResponseEntity)this.dbConnection.getTransactionTemplate(login).execute(arg_0 -> this.lambda$deleteInvoiceLists$13(login, (JdbcTemplate)jdbcTemplate, decryptedCodes, request, deletedErpCodes, successDelete, failerDelete, failerDeletedErpCodes, erpCodes, errors, arg_0));
    }

    private /* synthetic */ ResponseEntity lambda$deleteInvoiceLists$13(LoginDto login, JdbcTemplate jdbcTemplate, String[] decryptedCodes, Request request, List deletedErpCodes, Map successDelete, List failerDelete, Map failerDeletedErpCodes, String[] erpCodes, List errors, TransactionStatus status) {
        try {
            if (login.getIsMyHoloo().booleanValue() || login.getIsTorfehNegar().booleanValue()) {
                throw new TncException(TncExceptionMessages.INVALID_ACCESS_FOR_UPDATE_INVOICE);
            }
            SqlRowSet rs = jdbcTemplate.queryForRowSet("SELECT c.c_name name ,dbo.MiladiToShamsi(fac_date) date, * FROM facture f left join  Customer c on c.c_code = f.c_code WHERE fac_code IN (" + ConvertStr.commaBindStringsWithQuotes(Arrays.asList(decryptedCodes)) + ") AND Fac_Type = 'F'");
            while (rs.next()) {
                String fCode = rs.getString("fac_code");
                String fType = rs.getString("fac_type");
                String string = ConvertStr.encrypt((String)fCode);
                try {
                    InvoiceDto.InvoiceInfo invoice = new InvoiceDto.InvoiceInfo();
                    invoice.setId(fCode);
                    invoice.setType(fType);
                    int type = invoice.getType().equalsIgnoreCase("f") ? 1 : 3;
                    InvoiceType invoiceType = InvoiceType.getInvoiceType((int)type, (int)2);
                    invoice.setType(invoiceType.getSymbol());
                    invoice.setInvoiceType(invoiceType);
                    invoice.setErpcode(ConvertStr.encrypt((String)invoice.getId()));
                    invoice.setRegisterType(2);
                    invoice.setCustomername(rs.getString("name"));
                    invoice.setDate(rs.getString("date"));
                    invoice.setCustomerid(rs.getString("c_code"));
                    invoice.setSumprice(rs.getDouble("sum_price"));
                    this.validationForEditAndDeleteFacture(jdbcTemplate, invoice, invoice.getInvoiceType(), 2);
                    new InvoiceProcessDao(this.dbConnection, login, invoice.toString()).insert((Object)invoice, ProcessDao.ProcessKind.DELETE);
                    this.deleteInvoice(login, invoice, 2, request);
                    deletedErpCodes.add(string);
                    successDelete.putIfAbsent("ErpCode", deletedErpCodes);
                }
                catch (TncException tnc) {
                    failerDelete.add(string);
                    failerDeletedErpCodes.putIfAbsent("ErpCode", failerDelete);
                }
            }
            for (String code : erpCodes) {
                if (deletedErpCodes.contains(code) || failerDelete.contains(code)) continue;
                failerDelete.add(code);
                failerDeletedErpCodes.putIfAbsent("ErpCode", failerDelete);
            }
            errors.add(failerDeletedErpCodes);
        }
        catch (TncException e) {
            status.setRollbackOnly();
            return ConvertStr.getMapResponseEntity((String)"Invoice", Collections.singletonList(e.getErrorMap()), Collections.emptyList());
        }
        catch (Exception e) {
            status.setRollbackOnly();
            TncException tncException = new TncException(TncExceptionMessages.DEFAULT_ERROR);
            return ConvertStr.getMapResponseEntity((String)"Invoice", Collections.singletonList(tncException.makeErrorWithCause((Throwable)e)), Collections.emptyList());
        }
        return ConvertStr.getMapResponseEntity((String)"Invoice", (List)errors, Collections.singletonList(Collections.singletonMap("deleted", successDelete)));
    }

    private static /* synthetic */ double lambda$postInvoice$3(InvoiceDetailDto detailInfo) {
        return detailInfo.getPrice() * detailInfo.getSellercommission() * detailInfo.getFew() / 100.0;
    }

    private /* synthetic */ ProxyInvoiceService lambda$postInvoice$2(LoginDto myLogin) {
        return new ProxyInvoiceService(DbLogin.getInstance((DbConnection)this.dbConnection, (LoginDto)myLogin));
    }
}

